/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.paoding.rose.jade.statement.expression.ExprResolver;
import net.paoding.rose.jade.statement.expression.ExqlContext;
import net.paoding.rose.jade.statement.expression.ExqlPattern;
import net.paoding.rose.jade.statement.expression.ExqlUnit;
import net.paoding.rose.jade.statement.expression.impl.ExprResolverImpl;
import net.paoding.rose.jade.statement.expression.impl.ExqlCompiler;
import net.paoding.rose.jade.statement.expression.impl.ExqlContextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExqlPatternImpl
implements ExqlPattern {
    private static final Log logger = LogFactory.getLog(ExqlPattern.class);
    private static final ConcurrentHashMap<String, ExqlPattern> cache = new ConcurrentHashMap();
    protected final String pattern;
    protected final ExqlUnit unit;

    protected ExqlPatternImpl(String pattern, ExqlUnit unit) {
        this.pattern = pattern;
        this.unit = unit;
    }

    public static ExqlPattern compile(String pattern) {
        ExqlPattern compiledPattern = cache.get(pattern);
        if (compiledPattern == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EXQL pattern compiling:\n    pattern: " + pattern));
            }
            ExqlCompiler compiler = new ExqlCompiler(pattern);
            compiledPattern = compiler.compile();
            cache.putIfAbsent(pattern, compiledPattern);
        }
        return compiledPattern;
    }

    @Override
    public String execute(ExqlContext context, Map<String, ?> map) throws Exception {
        return this.execute(context, new ExprResolverImpl(map));
    }

    @Override
    public String execute(ExqlContext context, Map<String, ?> mapVars, Map<String, ?> mapConsts) throws Exception {
        return this.execute(context, new ExprResolverImpl(mapVars, mapConsts));
    }

    protected String execute(ExqlContext context, ExprResolver exprResolver) throws Exception {
        this.unit.fill(context, exprResolver);
        String flushOut = context.flushOut();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("EXQL pattern executing:\n    origin: " + this.pattern + "\n    result: " + flushOut + "\n    params: " + Arrays.toString(context.getParams())));
        }
        return flushOut;
    }

    public static void main(String ... args) throws Exception {
        ExqlPattern pattern = ExqlPatternImpl.compile("SELECT #(:expr1.length()), :expr2.class.name, ##(:expr3) WHERE #if(:expr4) {e = :expr4} #else {e IS NULL}#for(variant in :expr5.bytes) { AND c = :variant} GROUP BY #!(:expr1) ASC");
        ExqlContextImpl context = new ExqlContextImpl(1024);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expr1", "expr1");
        map.put("expr2", "expr2");
        map.put("expr3", "expr3");
        map.put("expr4", "expr4");
        map.put("expr5", "expr5");
        System.out.println(pattern.execute(context, map));
        System.out.println(Arrays.toString(context.getParams()));
    }
}

