/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.jade.statement.expression.ExprResolver;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.lang.math.NumberUtils;

public class ExprResolverImpl
implements ExprResolver {
    protected static final ConcurrentHashMap<String, Expression> cache = new ConcurrentHashMap();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(\\:|\\$)([a-zA-Z0-9_]+)(\\.[a-zA-Z0-9_]+)*");
    private static final Pattern MAP_PATTERN = Pattern.compile("\\[([\\.a-zA-Z0-9_]+)\\]");
    private static final String CONST_PREFIX = "_mapConsts";
    private static final String VAR_PREFIX = "_mapVars";
    protected final Map<String, Object> mapVars = new HashMap<String, Object>();
    protected final Map<String, Object> mapConsts = new HashMap<String, Object>();
    protected final JexlContext context = JexlHelper.createContext();

    public ExprResolverImpl() {
        Map map = this.context.getVars();
        map.put(VAR_PREFIX, this.mapVars);
        map.put(CONST_PREFIX, this.mapConsts);
    }

    public ExprResolverImpl(Map<String, ?> mapVars) {
        this();
        this.mapVars.putAll(mapVars);
    }

    public ExprResolverImpl(Map<String, ?> mapVars, Map<String, ?> mapConsts) {
        this();
        this.mapVars.putAll(mapVars);
        this.mapConsts.putAll(mapConsts);
    }

    public Map<String, ?> getVars() {
        return this.mapVars;
    }

    public void setVars(Map<String, ?> map) {
        this.mapVars.putAll(map);
    }

    public Map<String, ?> getConstants() {
        return this.mapConsts;
    }

    public void setConstants(Map<String, ?> map) {
        this.mapConsts.putAll(map);
    }

    @Override
    public Object executeExpr(String expression) throws Exception {
        Expression expr = cache.get(expression);
        if (expr == null) {
            String expression2;
            StringBuilder builder = new StringBuilder(expression.length() * 2);
            Matcher mapMatcher = MAP_PATTERN.matcher(expression);
            int index = 0;
            while (mapMatcher.find()) {
                builder.append(expression.substring(index, mapMatcher.start()));
                String t = mapMatcher.group(1);
                if (!NumberUtils.isDigits((String)t)) {
                    builder.append("['");
                    builder.append(mapMatcher.group(1));
                    builder.append("']");
                } else {
                    builder.append(mapMatcher.group(0));
                }
                index = mapMatcher.end();
            }
            if (builder.length() == 0) {
                expression2 = expression;
            } else {
                builder.append(expression.substring(index));
                expression2 = builder.toString();
                builder.setLength(0);
            }
            index = 0;
            Matcher matcher = PREFIX_PATTERN.matcher(expression2);
            while (matcher.find()) {
                builder.append(expression2.substring(index, matcher.start()));
                String prefix = matcher.group(1);
                String name = matcher.group(2);
                if (":".equals(prefix)) {
                    boolean isDigits = NumberUtils.isDigits((String)name);
                    if (isDigits) {
                        name = ':' + name;
                    }
                    if (!this.mapVars.containsKey(name)) {
                        throw new IllegalArgumentException("Variable '" + name + "' not defined in DAO method");
                    }
                    builder.append(VAR_PREFIX);
                    builder.append("['");
                    builder.append(name);
                    builder.append("']");
                } else if ("$".equals(prefix)) {
                    if (!this.mapConsts.containsKey(name)) {
                        throw new IllegalArgumentException("Constant '" + name + "' not defined in DAO class");
                    }
                    builder.append(CONST_PREFIX);
                    builder.append("['");
                    builder.append(name);
                    builder.append("']");
                }
                index = matcher.end(2);
            }
            builder.append(expression2.substring(index));
            expr = ExpressionFactory.createExpression((String)builder.toString());
            cache.putIfAbsent(expression2, expr);
        }
        return expr.evaluate(this.context);
    }

    @Override
    public Object getVar(String variant) {
        return this.mapVars.get(variant);
    }

    @Override
    public void setVar(String variant, Object value) {
        this.mapVars.put(variant, value);
    }

    public static void main(String ... args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("current", new Date());
        map.put("numbers", new Integer[]{1, 2, 3, 5, 8, 13, 21, 34});
        map.put("index", 5);
        map.put(":2", 2);
        map.put("map", map);
        ExprResolverImpl exprResolver = new ExprResolverImpl(map, map);
        System.out.println("map['index']=" + exprResolver.executeExpr(":map[index]"));
        System.out.println("numbers[5]=" + exprResolver.executeExpr(":map[numbers][5]"));
        System.out.println(exprResolver.executeExpr("$numbers[:index] + :2"));
        System.out.println(exprResolver.executeExpr(":current.year - ($current.month + $current.day) - :2"));
        System.out.println(exprResolver.executeExpr(":current.year - ($current.month + $current.day) + $numbers[:index] + :2"));
    }

    public static void main2(String[] args) {
        StringBuilder sb = new StringBuilder(200);
        String ex = ":1.id[id.kkj][idkkj], :2[name], :3[age], :3[4]";
        Matcher m = MAP_PATTERN.matcher(ex);
        int index = 0;
        while (m.find()) {
            sb.append(ex.substring(index, m.start()));
            String t = m.group(1);
            if (!NumberUtils.isDigits((String)t)) {
                sb.append("['");
                sb.append(m.group(1));
                sb.append("']");
            } else {
                sb.append(m.group(0));
            }
            index = m.end();
        }
        sb.append(ex.substring(index));
        System.out.println(sb);
    }
}

