/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.paoding.rose.jade.annotation.ReturnGeneratedKeys;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.dataaccess.DataAccess;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.statement.Querier;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.StatementRuntime;
import org.apache.commons.lang.ClassUtils;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class UpdateQuerier
implements Querier {
    private final DataAccessFactory dataAccessProvider;
    private final Class<?> returnType;
    private final boolean returnGeneratedKeys;

    public UpdateQuerier(DataAccessFactory dataAccessProvider, StatementMetaData metaData) {
        this.dataAccessProvider = dataAccessProvider;
        Method method = metaData.getMethod();
        Class returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            returnType = ClassUtils.primitiveToWrapper(returnType);
        }
        this.returnType = returnType;
        this.returnGeneratedKeys = returnType != Void.TYPE && method.isAnnotationPresent(ReturnGeneratedKeys.class);
    }

    @Override
    public Object execute(SQLType sqlType, StatementRuntime ... runtimes) {
        switch (runtimes.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.executeSingle(runtimes[0], this.returnType);
            }
        }
        return this.executeBatch(runtimes);
    }

    private Object executeSingle(StatementRuntime runtime, Class<?> returnType) {
        Number result;
        DataAccess dataAccess = this.dataAccessProvider.getDataAccess(runtime.getMetaData(), runtime.getProperties());
        if (this.returnGeneratedKeys) {
            ArrayList keys = new ArrayList(1);
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder(keys);
            dataAccess.update(runtime.getSQL(), runtime.getArgs(), (KeyHolder)generatedKeyHolder);
            result = keys.size() > 0 ? generatedKeyHolder.getKey() : null;
        } else {
            result = new Integer(dataAccess.update(runtime.getSQL(), runtime.getArgs(), null));
        }
        if (result == null || returnType == Void.TYPE) {
            return null;
        }
        if (returnType == result.getClass()) {
            return result;
        }
        if (returnType == Integer.class) {
            return result.intValue();
        }
        if (returnType == Long.class) {
            return result.longValue();
        }
        if (returnType == Boolean.class) {
            return result.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (returnType == Double.class) {
            return result.doubleValue();
        }
        if (returnType == Float.class) {
            return Float.valueOf(result.floatValue());
        }
        if (Number.class.isAssignableFrom(returnType)) {
            return result;
        }
        throw new DataRetrievalFailureException("The generated key is not of a supported numeric type. Unable to cast [" + result.getClass().getName() + "] to [" + Number.class.getName() + "]");
    }

    private Object executeBatch(StatementRuntime ... runtimes) {
        int[] updatedArray = new int[runtimes.length];
        HashMap batchs = new HashMap();
        for (int i = 0; i < runtimes.length; ++i) {
            StatementRuntime runtime = runtimes[i];
            LinkedList<StatementRuntime> batch = (LinkedList<StatementRuntime>)batchs.get(runtime.getSQL());
            if (batch == null) {
                batch = new LinkedList<StatementRuntime>();
                batchs.put(runtime.getSQL(), batch);
            }
            runtime.setProperty("_index_at_batch_", i);
            batch.add(runtime);
        }
        for (Map.Entry batch : batchs.entrySet()) {
            String sql = (String)batch.getKey();
            List batchRuntimes = (List)batch.getValue();
            StatementRuntime runtime = (StatementRuntime)batchRuntimes.get(0);
            DataAccess dataAccess = this.dataAccessProvider.getDataAccess(runtime.getMetaData(), runtime.getProperties());
            ArrayList<Object[]> argsList = new ArrayList<Object[]>(batchRuntimes.size());
            for (StatementRuntime batchRuntime : batchRuntimes) {
                argsList.add(batchRuntime.getArgs());
            }
            int[] batchResult = dataAccess.batchUpdate(sql, argsList);
            if (batchs.size() == 1) {
                updatedArray = batchResult;
                continue;
            }
            int index_at_sub_batch = 0;
            for (StatementRuntime batchRuntime : batchRuntimes) {
                Integer _index_at_batch_ = (Integer)batchRuntime.getProperty("_index_at_batch_");
                updatedArray[_index_at_batch_.intValue()] = batchResult[index_at_sub_batch++];
            }
        }
        return updatedArray;
    }

    private Object _executeBatch(StatementRuntime ... runtimes) {
        int[] updatedArray = new int[runtimes.length];
        for (int i = 0; i < updatedArray.length; ++i) {
            StatementRuntime runtime = runtimes[i];
            updatedArray[i] = (Integer)this.executeSingle(runtime, Integer.class);
        }
        return updatedArray;
    }
}

