/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.StatementRuntime;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.BeanWrapperImpl;

public class SimpleInterpreter
implements Interpreter {
    private static final Pattern NAMED_PARAM_PATTERN = Pattern.compile("(\\:([a-zA-Z0-9_\\.]+))");

    @Override
    public void interpret(StatementRuntime runtime) {
        LinkedList<Object> parametersAsList = new LinkedList<Object>();
        Matcher matcher = NAMED_PARAM_PATTERN.matcher(runtime.getSQL());
        if (!matcher.find()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        do {
            String name;
            if (NumberUtils.isDigits((String)(name = matcher.group(1)))) {
                name = matcher.group();
            }
            Object value = null;
            int find = name.indexOf(46);
            if (find >= 0) {
                Object bean = runtime.getParameters().get(name.substring(0, find));
                if (bean != null) {
                    BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
                    value = beanWrapper.getPropertyValue(name.substring(find + 1));
                }
            } else {
                value = runtime.getParameters().get(name);
            }
            builder.append(runtime.getSQL().substring(index, matcher.start()));
            if (value instanceof Collection) {
                builder.append('(');
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    builder.append("NULL");
                } else {
                    builder.append('?');
                }
                for (int i = 1; i < collection.size(); ++i) {
                    builder.append(", ?");
                }
                builder.append(')');
                parametersAsList.addAll(collection);
            } else {
                builder.append('?');
                parametersAsList.add(value);
            }
            index = matcher.end();
        } while (matcher.find());
        builder.append(runtime.getSQL().substring(index));
        runtime.setSQL(builder.toString());
        runtime.setArgs(parametersAsList.toArray());
    }
}

