/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.dataaccess.DataAccess;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.statement.Querier;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.StatementRuntime;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;

public class SelectQuerier
implements Querier {
    private final RowMapper rowMapper;
    private final Class<?> returnType;
    private final DataAccessFactory dataAccessProvider;
    private final ResultConverter converter;

    public SelectQuerier(DataAccessFactory dataAccessProvider, StatementMetaData metaData, RowMapper rowMapper) {
        this.dataAccessProvider = dataAccessProvider;
        this.returnType = metaData.getReturnType();
        this.rowMapper = rowMapper;
        this.converter = this.makeResultConveter();
    }

    @Override
    public Object execute(SQLType sqlType, StatementRuntime ... runtimes) {
        return this.execute(sqlType, runtimes[0]);
    }

    public Object execute(SQLType sqlType, StatementRuntime runtime) {
        DataAccess dataAccess = this.dataAccessProvider.getDataAccess(runtime.getMetaData(), runtime.getProperties());
        List listResult = dataAccess.select(runtime.getSQL(), runtime.getArgs(), this.rowMapper);
        return this.converter.convert(runtime, listResult);
    }

    protected ResultConverter makeResultConveter() {
        ResultConverter converter = List.class == this.returnType || Collection.class == this.returnType || Iterable.class == this.returnType ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                return listResult;
            }
        } : (ArrayList.class == this.returnType ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                return new ArrayList(listResult);
            }
        } : (LinkedList.class == this.returnType ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                return new LinkedList(listResult);
            }
        } : (Set.class == this.returnType || HashSet.class == this.returnType ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                return new HashSet(listResult);
            }
        } : (Collection.class.isAssignableFrom(this.returnType) ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                Collection listToReturn;
                try {
                    listToReturn = (Collection)SelectQuerier.this.returnType.newInstance();
                }
                catch (Exception e) {
                    throw new Error("error to create instance of " + SelectQuerier.this.returnType.getName());
                }
                listToReturn.addAll(listResult);
                return listToReturn;
            }
        } : (Iterator.class == this.returnType ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                return listResult.iterator();
            }
        } : (this.returnType.isArray() && byte[].class != this.returnType ? (this.returnType.getComponentType().isPrimitive() ? new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                Object array = Array.newInstance(SelectQuerier.this.returnType.getComponentType(), listResult.size());
                int len = listResult.size();
                for (int i = 0; i < len; ++i) {
                    Array.set(array, i, listResult.get(i));
                }
                return array;
            }
        } : new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                Object array = Array.newInstance(SelectQuerier.this.returnType.getComponentType(), listResult.size());
                return listResult.toArray((Object[])array);
            }
        }) : (Map.class == this.returnType || HashMap.class == this.returnType ? new MapConverter(){

            @Override
            protected Map creatMap(StatementRuntime runtime) {
                return new HashMap();
            }
        } : (Hashtable.class == this.returnType ? new MapConverter(){

            @Override
            protected Map creatMap(StatementRuntime runtime) {
                return new Hashtable();
            }
        } : (Map.class.isAssignableFrom(this.returnType) ? new MapConverter(){

            @Override
            protected Map creatMap(StatementRuntime runtime) {
                try {
                    return (Map)SelectQuerier.this.returnType.newInstance();
                }
                catch (Exception e) {
                    throw new Error("error to create instance of " + SelectQuerier.this.returnType.getName());
                }
            }
        } : new ResultConverter(){

            @Override
            public Object convert(StatementRuntime runtime, List<?> listResult) {
                int sizeResult = listResult.size();
                if (sizeResult == 1) {
                    return listResult.get(0);
                }
                if (sizeResult == 0) {
                    if (SelectQuerier.this.returnType.isPrimitive()) {
                        String msg = "Incorrect result size: expected 1, actual " + sizeResult + ": " + runtime.getMetaData();
                        throw new EmptyResultDataAccessException(msg, 1);
                    }
                    return null;
                }
                String msg = "Incorrect result size: expected 0 or 1, actual " + sizeResult + ": " + runtime.getMetaData();
                throw new IncorrectResultSizeDataAccessException(msg, 1, sizeResult);
            }
        })))))))));
        return converter;
    }

    static abstract class MapConverter
    implements ResultConverter {
        MapConverter() {
        }

        @Override
        public Object convert(StatementRuntime runtime, List<?> listResult) {
            Map map = this.creatMap(runtime);
            for (Object obj : listResult) {
                if (obj == null) continue;
                Map.Entry entry = (Map.Entry)obj;
                if (map.getClass() == Hashtable.class && entry.getKey() == null) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }

        protected abstract Map creatMap(StatementRuntime var1);
    }

    static interface ResultConverter {
        public Object convert(StatementRuntime var1, List<?> var2);
    }
}

