/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import net.paoding.rose.jade.statement.DAOMetaData;
import net.paoding.rose.jade.statement.StatementMetaData;

public class GenericUtils {
    private static final Class[] EMPTY_CLASSES = new Class[0];

    public static Class[] getActualClass(Type genericType, DAOMetaData daoMetaData) {
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            Class[] actualClasses = new Class[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                Type actualType = actualTypes[i];
                if (actualType instanceof Class) {
                    actualClasses[i] = (Class)actualType;
                    continue;
                }
                if (actualType instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                    actualClasses[i] = Array.newInstance((Class)componentType, 0).getClass();
                    continue;
                }
                if (actualType instanceof TypeVariable) {
                    actualClasses[i] = GenericUtils.resolveTypeVariable(daoMetaData, (TypeVariable)actualType);
                    continue;
                }
                throw new IllegalArgumentException("unsupport DAO method: " + daoMetaData.getDAOClass().getName());
            }
            return actualClasses;
        }
        return EMPTY_CLASSES;
    }

    public static final Class getReturnType(StatementMetaData smd) {
        Method method = smd.getMethod();
        DAOMetaData daoMetaData = smd.getDAOMetaData();
        if (method.getGenericReturnType() instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)method.getGenericReturnType();
            return GenericUtils.resolveTypeVariable(daoMetaData, v);
        }
        return method.getReturnType();
    }

    public static final Class resolveTypeVariable(DAOMetaData daoMetaData, TypeVariable key) {
        TypeVariable old;
        HashMap refs = new HashMap();
        LinkedList<Type> allSuperTypes = new LinkedList<Type>();
        allSuperTypes.addAll(Arrays.asList(daoMetaData.getDAOClass().getGenericInterfaces()));
        for (int i = 0; i < allSuperTypes.size(); ++i) {
            Type type = (Type)allSuperTypes.get(i);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class interfaceClass = (Class)parameterizedType.getRawType();
                int j = 0;
                for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                    TypeVariable v = interfaceClass.getTypeParameters()[j++];
                    refs.put(v, actualTypeArgument);
                }
                for (Type t : interfaceClass.getGenericInterfaces()) {
                    if (allSuperTypes.contains(t)) continue;
                    allSuperTypes.add(t);
                }
                continue;
            }
            for (Type t : ((Class)type).getGenericInterfaces()) {
                if (allSuperTypes.contains(t)) continue;
                allSuperTypes.add(t);
            }
        }
        Type returnType = key;
        do {
            old = returnType;
            if (!((returnType = (Type)refs.get(returnType)) instanceof Class)) continue;
            return (Class)returnType;
        } while (returnType != null);
        returnType = old;
        return (Class)returnType.getBounds()[0];
    }

    public static Map<String, ?> getConstantFrom(Class<?> clazz, boolean findAncestor, boolean findInterfaces) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (findInterfaces) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                GenericUtils.fillConstantFrom(interfaceClass, map);
            }
        }
        if (findAncestor) {
            for (Class<?> superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
                GenericUtils.fillConstantFrom(superClass, map);
            }
        }
        GenericUtils.fillConstantFrom(clazz, map);
        return map;
    }

    protected static void fillConstantFrom(Class<?> clazz, HashMap<String, Object> map) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (field.isSynthetic() || !Modifier.isStatic(modifiers = field.getModifiers())) continue;
            try {
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                map.put(field.getName(), field.get(null));
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public static void main(String ... args) {
        Map<String, ?> constants = GenericUtils.getConstantFrom(Character.class, true, true);
        System.out.println(constants);
        for (Method method : ClassLoader.class.getMethods()) {
            Object[] classes = GenericUtils.getActualClass(method.getGenericReturnType(), null);
            System.out.print(method.getName() + " = ");
            System.out.println(Arrays.toString(classes));
        }
        Type genericSuperclassType = Properties.class.getGenericSuperclass();
        System.out.print(genericSuperclassType + " = ");
        System.out.println(Arrays.toString(GenericUtils.getActualClass(genericSuperclassType, null)));
        for (Type genericInterfaceType : Properties.class.getGenericInterfaces()) {
            Object[] classes = GenericUtils.getActualClass(genericInterfaceType, null);
            System.out.print(genericInterfaceType + " = ");
            System.out.println(Arrays.toString(classes));
        }
    }
}

