/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.util.Collections;
import java.util.Map;
import net.paoding.rose.jade.statement.GenericUtils;

public class DAOMetaData {
    private final Class<?> daoClass;
    private final Map<String, ?> constants;

    public DAOMetaData(Class<?> daoClass) {
        this.daoClass = daoClass;
        this.constants = Collections.unmodifiableMap(GenericUtils.getConstantFrom(daoClass, true, true));
    }

    public Class<?> getDAOClass() {
        return this.daoClass;
    }

    public Map<String, ?> getConstants() {
        return this.constants;
    }

    public <T> T getConstant(String fieldName) {
        return (T)this.constants.get(fieldName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DAOMetaData) {
            DAOMetaData other = (DAOMetaData)obj;
            return this.daoClass.equals(other.daoClass);
        }
        return false;
    }

    public int hashCode() {
        return this.daoClass.hashCode() * 13;
    }

    public String toString() {
        return this.daoClass.getName();
    }
}

