/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.rowmapper;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class ArrayRowMapper
implements RowMapper {
    private Class<?> componentType;

    public ArrayRowMapper(Class<?> returnType) {
        this.componentType = returnType.getComponentType();
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        int columnSize = rs.getMetaData().getColumnCount();
        Object array = Array.newInstance(this.componentType, columnSize);
        for (int i = 0; i < columnSize; ++i) {
            Object value = JdbcUtils.getResultSetValue((ResultSet)rs, (int)(i + 1), this.componentType);
            Array.set(array, i, value);
        }
        return array;
    }
}

