/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.rowmapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class AbstractCollectionRowMapper
implements RowMapper {
    private Class<?> elementType;

    public AbstractCollectionRowMapper(StatementMetaData modifier) {
        Class<?>[] genericTypes = modifier.getGenericReturnTypes();
        if (genericTypes.length < 1) {
            throw new IllegalArgumentException("Collection generic");
        }
        this.elementType = genericTypes[0];
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        int columnSize = rs.getMetaData().getColumnCount();
        Collection collection = this.createCollection(columnSize);
        for (int columnIndex = 1; columnIndex <= columnSize; ++columnIndex) {
            collection.add(JdbcUtils.getResultSetValue((ResultSet)rs, (int)columnIndex, this.elementType));
        }
        return collection;
    }

    protected abstract Collection createCollection(int var1);
}

