/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.dataaccess.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.DataSourceHolder;
import net.paoding.rose.jade.statement.StatementMetaData;

public class RandomDataSourceFactory
implements DataSourceFactory {
    private Random random = new Random();
    private List<DataSourceHolder> dataSources = Collections.emptyList();

    public RandomDataSourceFactory() {
    }

    public void addDataSource(DataSource dataSource) {
        if (this.dataSources.size() == 0) {
            this.dataSources = new ArrayList<DataSourceHolder>(this.dataSources);
        }
        this.dataSources.add(new DataSourceHolder(dataSource));
    }

    public RandomDataSourceFactory(List<DataSource> dataSources) {
        this.setDataSources(dataSources);
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = new ArrayList<DataSourceHolder>(dataSources.size());
        for (DataSource dataSource : dataSources) {
            this.dataSources.add(new DataSourceHolder(dataSource));
        }
    }

    @Override
    public DataSourceHolder getHolder(StatementMetaData metaData, Map<String, Object> runtimeProperties) {
        if (this.dataSources.size() == 0) {
            return null;
        }
        int index = this.random.nextInt(this.dataSources.size());
        return this.dataSources.get(index);
    }
}

