/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.dataaccess.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.DataSourceHolder;
import net.paoding.rose.jade.dataaccess.datasource.RandomDataSourceFactory;
import net.paoding.rose.jade.dataaccess.datasource.SimpleDataSourceFactory;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.springframework.util.CollectionUtils;

public class MasterSlaveDataSourceFactory
implements DataSourceFactory {
    private DataSourceFactory masters = new RandomDataSourceFactory();
    private DataSourceFactory slaves = new RandomDataSourceFactory();

    public MasterSlaveDataSourceFactory() {
    }

    public MasterSlaveDataSourceFactory(DataSource master, List<DataSource> slaves, boolean queryFromMaster) {
        if (queryFromMaster && !CollectionUtils.containsInstance(slaves, (Object)master)) {
            slaves = new ArrayList<DataSource>(slaves);
            slaves.add(master);
        }
        this.setSlaves(new RandomDataSourceFactory(slaves));
        this.setMasters(new SimpleDataSourceFactory(master));
    }

    public void setMasters(DataSourceFactory masters) {
        this.masters = masters;
    }

    public void setSlaves(DataSourceFactory slaves) {
        this.slaves = slaves;
    }

    @Override
    public DataSourceHolder getHolder(StatementMetaData metaData, Map<String, Object> runtimeProperties) {
        if (metaData.getSQLType() != SQLType.READ) {
            return this.masters.getHolder(metaData, runtimeProperties);
        }
        return this.slaves.getHolder(metaData, runtimeProperties);
    }
}

