/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.dataaccess.datasource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.DataSourceHolder;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.apache.commons.lang.StringUtils;

public class HierarchicalDataSourceFactory
implements DataSourceFactory {
    private ConcurrentHashMap<String, DataSourceHolder> dataSources = new ConcurrentHashMap();
    private DataSourceHolder defaultDataSource;

    public HierarchicalDataSourceFactory() {
    }

    public HierarchicalDataSourceFactory(DataSource defaultDataSource) {
        this.defaultDataSource = new DataSourceHolder(defaultDataSource);
    }

    public void registerDataSource(String name, DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("blank name");
        }
        if (name.equals("*")) {
            this.defaultDataSource = new DataSourceHolder(dataSource);
        } else {
            this.dataSources.putIfAbsent(name, new DataSourceHolder(dataSource));
        }
    }

    public void registerDataSource(String name, DataSourceFactory dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("blank name");
        }
        if (name.equals("*")) {
            this.defaultDataSource = new DataSourceHolder(dataSource);
        } else {
            this.dataSources.putIfAbsent(name, new DataSourceHolder(dataSource));
        }
    }

    @Override
    public DataSourceHolder getHolder(StatementMetaData metaData, Map<String, Object> runtime) {
        int index;
        String daoName = metaData.getDAOMetaData().getDAOClass().getName();
        String name = daoName;
        DataSourceHolder dataSource = this.dataSources.get(name);
        if (dataSource != null) {
            return dataSource;
        }
        do {
            if ((index = name.lastIndexOf(46)) != -1) continue;
            this.dataSources.putIfAbsent(daoName, this.defaultDataSource);
            return this.defaultDataSource;
        } while ((dataSource = this.dataSources.get(name = name.substring(0, index))) == null);
        this.dataSources.putIfAbsent(daoName, dataSource);
        return dataSource;
    }
}

