/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.paoding.rose.jade.statement.DefaultInterpreterFactory;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.InterpreterComparator;
import net.paoding.rose.jade.statement.InterpreterFactory;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringInterpreterFactory
implements InterpreterFactory,
ApplicationContextAware {
    private DefaultInterpreterFactory interpreterFactory;
    private ListableBeanFactory beanFactory;

    public SpringInterpreterFactory() {
    }

    public SpringInterpreterFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    @Override
    public Interpreter[] getInterpreters(StatementMetaData metaData) {
        if (this.interpreterFactory == null) {
            this.init();
        }
        return this.interpreterFactory.getInterpreters(metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        SpringInterpreterFactory springInterpreterFactory = this;
        synchronized (springInterpreterFactory) {
            if (this.interpreterFactory == null) {
                Map map = this.beanFactory.getBeansOfType(Interpreter.class);
                ArrayList<Interpreter> interpreters = new ArrayList<Interpreter>(map.values());
                Collections.sort(interpreters, new InterpreterComparator());
                this.interpreterFactory = new DefaultInterpreterFactory(interpreters);
            }
        }
    }
}

