/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.spring;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.paoding.rose.jade.annotation.DAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

public class JadeComponentProvider
implements ResourceLoaderAware {
    private final Log logger = LogFactory.getLog(JadeComponentProvider.class);
    private String resourcePattern = "**/*DAO.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();

    public JadeComponentProvider() {
        this.includeFilters.add((TypeFilter)new AnnotationTypeFilter(DAO.class));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourcePatternResolver;
    }

    public void setResourcePattern(String resourcePattern) {
        Assert.notNull((Object)resourcePattern, (String)"'resourcePattern' must not be null");
        this.resourcePattern = resourcePattern;
    }

    public void addExcludeFilter(TypeFilter excludeFilter) {
        this.excludeFilters.add(0, excludeFilter);
    }

    public Set<BeanDefinition> findCandidateComponents(String uriPrefix) {
        if (!uriPrefix.endsWith("/")) {
            uriPrefix = uriPrefix + "/";
        }
        LinkedHashSet<BeanDefinition> candidates = new LinkedHashSet<BeanDefinition>();
        try {
            String packageSearchPath = uriPrefix + this.resourcePattern;
            boolean traceEnabled = this.logger.isDebugEnabled();
            boolean debugEnabled = this.logger.isDebugEnabled();
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            if (debugEnabled) {
                this.logger.debug((Object)("[jade/find] find " + resources.length + " resources for " + packageSearchPath));
            }
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                if (traceEnabled) {
                    this.logger.trace((Object)("[jade/find] scanning " + resource));
                }
                if (!resource.exists()) {
                    if (!debugEnabled) continue;
                    this.logger.debug((Object)("Ignored because not exists:" + resource));
                    continue;
                }
                if (resource.isReadable()) {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                    if (this.isCandidateComponent(metadataReader)) {
                        ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                        sbd.setResource(resource);
                        sbd.setSource((Object)resource);
                        if (sbd.getMetadata().isInterface() && sbd.getMetadata().isIndependent()) {
                            if (debugEnabled) {
                                this.logger.debug((Object)("Identified candidate component class: " + resource));
                            }
                            candidates.add((BeanDefinition)sbd);
                            continue;
                        }
                        if (!traceEnabled) continue;
                        this.logger.trace((Object)("Ignored because not a interface top-level class: " + resource));
                        continue;
                    }
                    if (!traceEnabled) continue;
                    this.logger.trace((Object)("Ignored because not matching any filter: " + resource));
                    continue;
                }
                if (!traceEnabled) continue;
                this.logger.trace((Object)("Ignored because not readable: " + resource));
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during jade scanning", (Throwable)ex);
        }
        return candidates;
    }

    protected boolean isCandidateComponent(MetadataReader metadataReader) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }
}

