/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.application;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.sql.DataSource;
import net.paoding.rose.jade.context.JadeInvocationHandler;
import net.paoding.rose.jade.dataaccess.DataAccessFactoryAdapter;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.datasource.SimpleDataSourceFactory;
import net.paoding.rose.jade.rowmapper.DefaultRowMapperFactory;
import net.paoding.rose.jade.rowmapper.RowMapperFactory;
import net.paoding.rose.jade.statement.DAOMetaData;
import net.paoding.rose.jade.statement.DefaultInterpreterFactory;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.StatementWrapperProvider;
import net.paoding.rose.jade.statement.cached.CacheProvider;
import org.springframework.util.ClassUtils;

public class JadeFactory {
    private RowMapperFactory rowMapperFactory = new DefaultRowMapperFactory();
    private DefaultInterpreterFactory interpreterFactory = new DefaultInterpreterFactory();
    private DataAccessFactoryAdapter dataAccessFactory;
    private CacheProvider cacheProvider;
    private StatementWrapperProvider statementWrapperProvider;

    public JadeFactory() {
    }

    public JadeFactory(DataSource defaultDataSource) {
        this.setDataSourceFactory(new SimpleDataSourceFactory(defaultDataSource));
    }

    public JadeFactory(DataSourceFactory dataSourceFactory) {
        this.setDataSourceFactory(dataSourceFactory);
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataAccessFactory = new DataAccessFactoryAdapter(dataSourceFactory);
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public DataSourceFactory getDataSourceFactory() {
        if (this.dataAccessFactory == null) {
            return null;
        }
        return this.dataAccessFactory.getDataSourceFactory();
    }

    public void setRowMapperFactory(RowMapperFactory rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }

    public StatementWrapperProvider getStatementWrapperProvider() {
        return this.statementWrapperProvider;
    }

    public void setStatementWrapperProvider(StatementWrapperProvider statementWrapperProvider) {
        this.statementWrapperProvider = statementWrapperProvider;
    }

    public void addInterpreter(Interpreter ... interpreters) {
        for (Interpreter interpreter : interpreters) {
            this.interpreterFactory.addInterpreter(interpreter);
        }
    }

    public <T> T create(Class<?> daoClass) {
        try {
            DAOMetaData daoMetaData = new DAOMetaData(daoClass);
            JadeInvocationHandler handler = new JadeInvocationHandler(daoMetaData, this.interpreterFactory, this.rowMapperFactory, this.dataAccessFactory, this.cacheProvider, this.statementWrapperProvider);
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            return (T)Proxy.newProxyInstance(classLoader, new Class[]{daoClass}, (InvocationHandler)handler);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("failed to create bean for " + daoClass.getName(), e);
        }
    }
}

