/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import net.paoding.rose.jade.statement.expression.ExqlContext;
import net.paoding.rose.jade.statement.expression.util.ExqlUtils;

public class ExqlContextImpl
implements ExqlContext {
    private static final String NULL = "NULL";
    private static final char QUESTION = '?';
    private static final char COMMA = ',';
    protected final ArrayList<Object> params = new ArrayList();
    protected final StringBuilder builder;

    public ExqlContextImpl(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    @Override
    public Object[] getParams() {
        return this.params.toArray();
    }

    @Override
    public void fillChar(char ch) {
        this.builder.append(ch);
    }

    @Override
    public void fillText(String string) {
        this.builder.append(string);
    }

    @Override
    public void fillValue(Object obj) {
        if (obj instanceof Collection) {
            this.fillCollection((Collection)obj);
        } else if (obj != null && obj.getClass().isArray() && obj.getClass() != byte[].class) {
            this.fillCollection(ExqlUtils.asCollection(obj));
        } else {
            this.setParam(obj);
            this.builder.append('?');
        }
    }

    @Override
    public String flushOut() {
        return this.builder.toString();
    }

    public String toString() {
        return this.flushOut();
    }

    protected void setParam(Object value) {
        this.params.add(value);
    }

    private void fillCollection(Collection<?> collection) {
        int count = 0;
        if (collection.isEmpty()) {
            this.builder.append(NULL);
        } else {
            for (Object value : collection) {
                if (value == null) continue;
                if (count > 0) {
                    this.builder.append(',');
                }
                this.setParam(value);
                this.builder.append('?');
                ++count;
            }
        }
    }

    public static void main(String ... args) throws Exception {
        ExqlContextImpl context = new ExqlContextImpl(1024);
        context.fillText("WHERE uid = ");
        context.fillValue(102);
        context.fillText(" AND sid IN (");
        context.fillValue(new int[]{11, 12, 24, 25, 31, 32, 33});
        context.fillText(") AND (create_time > ");
        context.fillValue(new Date());
        context.fillText(" OR create_time <= ");
        context.fillValue(new Date());
        context.fillChar(')');
        System.out.println(context.flushOut());
        System.out.println(Arrays.toString(context.getParams()));
    }
}

