/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.jade.statement.expression.ExqlPattern;
import net.paoding.rose.jade.statement.expression.ExqlUnit;
import net.paoding.rose.jade.statement.expression.impl.BunchUnit;
import net.paoding.rose.jade.statement.expression.impl.ChoiceUnit;
import net.paoding.rose.jade.statement.expression.impl.EmptyUnit;
import net.paoding.rose.jade.statement.expression.impl.ExprUnit;
import net.paoding.rose.jade.statement.expression.impl.ExqlContextImpl;
import net.paoding.rose.jade.statement.expression.impl.ExqlPatternImpl;
import net.paoding.rose.jade.statement.expression.impl.ForEachUnit;
import net.paoding.rose.jade.statement.expression.impl.JoinExprUnit;
import net.paoding.rose.jade.statement.expression.impl.OptionUnit;
import net.paoding.rose.jade.statement.expression.impl.TextUnit;

public class ExqlCompiler {
    private static final char BRACE_LEFT = '(';
    private static final char BRACE_RIGHT = ')';
    private static final char BLOCK_LEFT = '{';
    private static final char BLOCK_RIGHT = '}';
    private static final String SHARP = "#";
    private static final String JOIN = "!";
    private static final String KEYWORD_IF = "if";
    private static final String KEYWORD_FOR = "for";
    private static final String SHARP_ELSE = "#else";
    private static final Pattern PATTERN_KEYWORD = Pattern.compile("\\:\\:|([\\:\\$]{1}[a-zA-Z0-9_\\.]+)|\\{([^\\{\\}]+)\\}\\?|#(#|!|if|for)?");
    private static final Pattern PATTERN_IN = Pattern.compile("([a-zA-Z0-9_]*)\\s+in\\s+(.+)");
    private final String pattern;
    private final int length;
    private int position = 0;

    public ExqlCompiler(String pattern) {
        this.pattern = pattern;
        this.length = pattern.length();
    }

    public ExqlPattern compile() {
        return new ExqlPatternImpl(this.pattern, this.compileUnit());
    }

    protected ExqlUnit compileUnit() {
        Matcher matcher = PATTERN_KEYWORD.matcher(this.pattern);
        ArrayList<ExqlUnit> units = new ArrayList<ExqlUnit>();
        int fromIndex = 0;
        while (this.position < this.length && matcher.find(this.position)) {
            ExqlUnit unit;
            this.position = matcher.end();
            String expr = matcher.group(1);
            if (expr != null) {
                if (matcher.start() > fromIndex) {
                    units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
                }
                if (expr.charAt(0) == '$') {
                    units.add(new JoinExprUnit(expr));
                } else {
                    units.add(new ExprUnit(expr));
                }
                fromIndex = this.position;
                continue;
            }
            String group = matcher.group(2);
            if (group != null) {
                if (matcher.start() > fromIndex) {
                    units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
                }
                ExqlCompiler compiler = new ExqlCompiler(group);
                unit = compiler.compileUnit();
                units.add(new OptionUnit(unit));
                fromIndex = this.position;
                continue;
            }
            String keyword = matcher.group(3);
            if (keyword == null) {
                expr = this.findBrace('(', ')');
                if (expr == null) continue;
                if (matcher.start() > fromIndex) {
                    units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
                }
                units.add(new ExprUnit(expr));
                fromIndex = this.position;
                continue;
            }
            if (keyword.equals(SHARP) || keyword.equals(JOIN)) {
                expr = this.findBrace('(', ')');
                if (expr == null) continue;
                if (matcher.start() > fromIndex) {
                    units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
                }
                units.add(new JoinExprUnit(expr));
                fromIndex = this.position;
                continue;
            }
            if (keyword.equals(KEYWORD_IF)) {
                ExqlUnit unitIfTrue;
                expr = this.findBrace('(', ')');
                if (expr == null || (unitIfTrue = this.compileBlock()) == null) continue;
                if (matcher.start() > fromIndex) {
                    units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
                }
                ExqlUnit unitIfFalse = null;
                if (this.match(SHARP_ELSE, this.position)) {
                    unitIfFalse = this.compileBlock();
                }
                units.add(new ChoiceUnit(expr, unitIfTrue, unitIfFalse));
                fromIndex = this.position;
                continue;
            }
            if (!keyword.equals(KEYWORD_FOR) || (expr = this.findBrace('(', ')')) == null || (unit = this.compileBlock()) == null) continue;
            if (matcher.start() > fromIndex) {
                units.add(new TextUnit(this.pattern.substring(fromIndex, matcher.start())));
            }
            String variant = null;
            Matcher matcherIn = PATTERN_IN.matcher(expr);
            if (matcherIn.matches()) {
                variant = matcherIn.group(1);
                expr = matcherIn.group(2);
            }
            units.add(new ForEachUnit(expr, variant, unit));
            fromIndex = this.position;
        }
        if (fromIndex < this.length) {
            units.add(new TextUnit(this.pattern.substring(fromIndex)));
        }
        if (units.size() > 1) {
            return new BunchUnit(units);
        }
        if (!units.isEmpty()) {
            return units.get(0);
        }
        return new EmptyUnit();
    }

    private int findLeftBrace(char chLeft, int fromIndex) {
        for (int index = fromIndex; index < this.length; ++index) {
            char ch = this.pattern.charAt(index);
            if (ch == chLeft) {
                return index;
            }
            if (Character.isWhitespace(ch)) continue;
            return -1;
        }
        return -1;
    }

    private int findRightBrace(char chLeft, char chRight, int fromIndex) {
        int level = 0;
        for (int index = fromIndex; index < this.length; ++index) {
            char ch = this.pattern.charAt(index);
            if (ch == chLeft) {
                ++level;
                continue;
            }
            if (ch != chRight) continue;
            if (level == 0) {
                return index;
            }
            --level;
        }
        return -1;
    }

    private String findBrace(char chLeft, char chRight) {
        int start;
        int end;
        int left = this.findLeftBrace(chLeft, this.position);
        if (left >= this.position && (end = this.findRightBrace(chLeft, chRight, start = left + 1)) >= start) {
            this.position = end + 1;
            return this.pattern.substring(start, end);
        }
        return null;
    }

    private ExqlUnit compileBlock() {
        String group = this.findBrace('{', '}');
        if (group != null) {
            ExqlCompiler compiler = new ExqlCompiler(group);
            return compiler.compileUnit();
        }
        return null;
    }

    private boolean match(String keyword, int fromIndex) {
        char ch;
        int index;
        int match = 0;
        for (index = fromIndex; index < this.length; ++index) {
            ch = this.pattern.charAt(index);
            if (Character.isWhitespace(ch)) continue;
            match = index;
            break;
        }
        for (index = 0; index < keyword.length(); ++index) {
            ch = this.pattern.charAt(match);
            if (ch != keyword.charAt(index)) {
                return false;
            }
            ++match;
        }
        this.position = match;
        return true;
    }

    public static void main(String ... args) throws Exception {
        String string = "SELECT :expr1, #($expr2.class), WHERE #if(:expr3) {e = $expr3} #else {e IS NULL}#for(variant in $expr4.bytes) { AND c = :variant} {AND d = :expr5}? {AND f = $expr6}? BY #!(:expr7) ASC";
        Matcher matcher = PATTERN_KEYWORD.matcher(string);
        int position = 0;
        while (matcher.find(position)) {
            System.out.println("===============================");
            System.out.println("group 0: " + matcher.group(0));
            System.out.println("group 1: " + matcher.group(1));
            System.out.println("group 2: " + matcher.group(2));
            System.out.println("group 3: " + matcher.group(3));
            position = matcher.end();
        }
        matcher = PATTERN_IN.matcher("variant in :expr5");
        if (matcher.matches()) {
            System.out.println("===============================");
            System.out.println("group 0: " + matcher.group(0));
            System.out.println("group 1: " + matcher.group(1));
            System.out.println("group 2: " + matcher.group(2));
        }
        ExqlPattern pattern = new ExqlCompiler(string).compile();
        ExqlContextImpl context = new ExqlContextImpl(string.length());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("expr1", "expr1");
        map.put("expr2", "expr2");
        map.put("expr3", "expr3");
        map.put("expr4", "expr4");
        map.put("expr5", "expr5");
        map.put("expr7", "expr7");
        System.out.println(pattern.execute(context, map, map));
        System.out.println(Arrays.toString(context.getParams()));
    }
}

