/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import net.paoding.rose.jade.statement.expression.ExprResolver;
import net.paoding.rose.jade.statement.expression.ExqlContext;
import net.paoding.rose.jade.statement.expression.ExqlUnit;
import net.paoding.rose.jade.statement.expression.util.ExqlUtils;

public class ChoiceUnit
implements ExqlUnit {
    private final String expr;
    private final ExqlUnit unitIfTrue;
    private final ExqlUnit unitIfFalse;

    public ChoiceUnit(String expr, ExqlUnit unit) {
        this.expr = expr;
        this.unitIfTrue = unit;
        this.unitIfFalse = null;
    }

    public ChoiceUnit(String expr, ExqlUnit unitIfTrue, ExqlUnit unitIfFalse) {
        this.expr = expr;
        this.unitIfTrue = unitIfTrue;
        this.unitIfFalse = unitIfFalse;
    }

    @Override
    public boolean isValid(ExprResolver exprResolver) {
        Object obj = ExqlUtils.execExpr(exprResolver, this.expr);
        if (ExqlUtils.asBoolean(obj)) {
            return this.unitIfTrue.isValid(exprResolver);
        }
        if (this.unitIfFalse != null) {
            return this.unitIfFalse.isValid(exprResolver);
        }
        return true;
    }

    @Override
    public void fill(ExqlContext exqlContext, ExprResolver exprResolver) throws Exception {
        Object obj = exprResolver.executeExpr(this.expr);
        if (ExqlUtils.asBoolean(obj)) {
            this.unitIfTrue.fill(exqlContext, exprResolver);
        } else if (this.unitIfFalse != null) {
            this.unitIfFalse.fill(exqlContext, exprResolver);
        }
    }
}

