/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.cached;

import java.util.concurrent.ConcurrentHashMap;
import net.paoding.rose.jade.statement.cached.CacheInterface;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockCache
implements CacheInterface {
    private static Log logger = LogFactory.getLog(MockCache.class);
    private ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();
    private String poolName;
    private int maxSize = 100;

    public MockCache(String poolName) {
        this.poolName = poolName;
    }

    public MockCache(String poolName, int maxSize) {
        this.poolName = poolName;
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public Object get(String key) {
        Object value = this.map.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get cache '" + key + "' from pool '" + this.poolName + "': " + value));
        }
        return value;
    }

    @Override
    public boolean set(String key, Object value, int expiry) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set cache '" + key + "' to pool '" + this.poolName + "': " + value));
        }
        if (this.map.size() >= this.maxSize) {
            this.map.remove(this.map.keys().nextElement());
        }
        this.map.put(key, value);
        return true;
    }

    @Override
    public boolean delete(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Remove cache '" + key + "' from pool '" + this.poolName + "'."));
        }
        this.map.remove(key);
        return true;
    }
}

