/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.cached;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.jade.annotation.Cache;
import net.paoding.rose.jade.annotation.CacheDelete;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.statement.Statement;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.cached.CacheInterface;
import net.paoding.rose.jade.statement.cached.CacheProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;

public class CachedStatement
implements Statement {
    private final Statement realStatement;
    private final Cache cacheAnnotation;
    private final CacheDelete cacheDeleteAnnotation;
    private final CacheProvider cacheProvider;
    private static final Pattern PATTERN = Pattern.compile("\\:([a-zA-Z0-9_\\.]*)");

    public CachedStatement(CacheProvider cacheProvider, Statement realStatement) {
        this.realStatement = realStatement;
        this.cacheProvider = cacheProvider;
        StatementMetaData metaData = realStatement.getMetaData();
        SQLType sqlType = metaData.getSQLType();
        this.cacheDeleteAnnotation = metaData.getMethod().getAnnotation(CacheDelete.class);
        Cache cacheAnnotation = metaData.getMethod().getAnnotation(Cache.class);
        if (sqlType == SQLType.READ) {
            this.cacheAnnotation = cacheAnnotation;
        } else {
            this.cacheAnnotation = null;
            if (cacheAnnotation != null) {
                Log logger = LogFactory.getLog(CachedStatement.class);
                logger.warn((Object)("@" + Cache.class.getName() + " is invalid for a " + (Object)((Object)sqlType) + " SQL:" + metaData.getSQL()));
            }
        }
    }

    @Override
    public StatementMetaData getMetaData() {
        return this.realStatement.getMetaData();
    }

    @Override
    public Object execute(Map<String, Object> parameters) {
        CacheInterface cache;
        Object value = null;
        if (this.cacheAnnotation == null) {
            value = this.realStatement.execute(parameters);
        } else {
            String cacheKey;
            cache = this.cacheProvider.getCacheByPool(this.getMetaData(), this.cacheAnnotation.pool());
            value = cache.get(cacheKey = CachedStatement.buildKey(this.cacheAnnotation.key(), parameters));
            if (value == null) {
                value = this.realStatement.execute(parameters);
                cache.set(cacheKey, value, this.cacheAnnotation.expiry());
            }
        }
        if (this.cacheDeleteAnnotation != null) {
            cache = this.cacheProvider.getCacheByPool(this.getMetaData(), this.cacheDeleteAnnotation.pool());
            for (String key : this.cacheDeleteAnnotation.key()) {
                String cacheKey = CachedStatement.buildKey(key, parameters);
                cache.delete(cacheKey);
            }
        }
        return value;
    }

    private static String buildKey(String key, Map<String, Object> parameters) {
        Matcher matcher = PATTERN.matcher(key);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder();
            int index = 0;
            do {
                String name = matcher.group(1).trim();
                Object value = null;
                int find = name.indexOf(46);
                if (find >= 0) {
                    Object bean = parameters.get(name.substring(0, find));
                    if (bean != null) {
                        value = new BeanWrapperImpl(bean).getPropertyValue(name.substring(find + 1));
                    }
                } else {
                    value = parameters.get(name);
                }
                builder.append(key.substring(index, matcher.start()));
                builder.append(value);
                index = matcher.end();
            } while (matcher.find());
            builder.append(key.substring(index));
            return builder.toString();
        }
        return key;
    }
}

