/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.HashMap;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.StatementRuntime;
import net.paoding.rose.jade.statement.expression.ExqlPattern;
import net.paoding.rose.jade.statement.expression.impl.ExqlContextImpl;
import net.paoding.rose.jade.statement.expression.impl.ExqlPatternImpl;
import org.springframework.jdbc.BadSqlGrammarException;

public class SystemInterpreter
implements Interpreter {
    @Override
    public void interpret(StatementRuntime runtime) {
        ExqlPattern pattern = ExqlPatternImpl.compile(runtime.getSQL());
        ExqlContextImpl context = new ExqlContextImpl(runtime.getSQL().length() + 32);
        try {
            pattern.execute(context, runtime.getParameters(), runtime.getMetaData().getDAOMetaData().getConstants());
            runtime.setArgs(context.getParams());
            runtime.setSQL(context.flushOut());
        }
        catch (Exception e) {
            String daoInfo = runtime.getMetaData().toString();
            throw new BadSqlGrammarException(daoInfo, runtime.getSQL(), (SQLException)new SQLSyntaxErrorException(daoInfo + " @SQL('" + runtime.getSQL() + "')", e));
        }
    }

    public static void main(String[] args) throws Exception {
        String sql = "insert ignore into table_name (`id`,`uid`,`favable_id`,`addtime`,`ranking`) values (:1,:2,now(),0)";
        ExqlPattern pattern = ExqlPatternImpl.compile(sql);
        ExqlContextImpl context = new ExqlContextImpl(sql.length() + 32);
        HashMap<String, String> parametersAsMap = new HashMap<String, String>();
        parametersAsMap.put(":1", "p1");
        parametersAsMap.put(":2", "p2");
        String result = pattern.execute(context, parametersAsMap);
        System.out.println(result);
    }
}

