/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.StatementRuntime;

public class StatementRuntimeImpl
implements StatementRuntime {
    private final StatementMetaData metaData;
    private final Map<String, Object> parameters;
    private String sql;
    private Object[] args;
    private Map<String, Object> properties;

    public StatementRuntimeImpl(StatementMetaData metaData, Map<String, Object> parameters) {
        this.metaData = metaData;
        this.parameters = parameters;
        this.sql = metaData.getSQL();
    }

    @Override
    public StatementMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setSQL(String sql) {
        this.sql = sql;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(Object[] args) {
        this.args = args;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    @Override
    public <T> T getProperty(String name) {
        return (T)(this.properties == null ? null : this.properties.get(name));
    }
}

