/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.paoding.rose.jade.annotation.SQL;
import net.paoding.rose.jade.annotation.SQLParam;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.annotation.ShardBy;
import net.paoding.rose.jade.statement.DAOMetaData;
import net.paoding.rose.jade.statement.GenericUtils;

public class StatementMetaData {
    private final DAOMetaData daoMetaData;
    private final Method method;
    private final String sql;
    private final SQLType sqlType;
    private final Class returnType;
    private final Class[] parameterTypesOfReturnType;
    private final SQLParam[] sqlParams;
    private final int shardByIndex;
    private final ShardBy shardBy;
    private final int parameterCount;
    private static Pattern[] SELECT_PATTERNS = new Pattern[]{Pattern.compile("^\\s*SELECT.*", 2), Pattern.compile("^\\s*GET.*", 2), Pattern.compile("^\\s*FIND.*", 2), Pattern.compile("^\\s*READ.*", 2), Pattern.compile("^\\s*QUERY.*", 2), Pattern.compile("^\\s*SHOW.*", 2), Pattern.compile("^\\s*DESC.*", 2), Pattern.compile("^\\s*DESCRIBE.*", 2)};

    public StatementMetaData(DAOMetaData daoMetaData, Method method) {
        this.daoMetaData = daoMetaData;
        this.method = method;
        SQL sqlAnnotation = method.getAnnotation(SQL.class);
        if (sqlAnnotation == null) {
            sqlAnnotation = new SQL(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return SQL.class;
                }

                @Override
                public String value() {
                    String toString = StatementMetaData.this.method.toString();
                    int paramStart = toString.indexOf("(");
                    int methodNameStart = toString.lastIndexOf(46, paramStart) + 1;
                    return toString.substring(methodNameStart) + "@" + StatementMetaData.this.method.getDeclaringClass().getName();
                }

                @Override
                public SQLType type() {
                    return SQLType.AUTO_DETECT;
                }
            };
        }
        this.sql = sqlAnnotation.value();
        this.sqlType = this.resolveSQLType(sqlAnnotation);
        this.returnType = GenericUtils.resolveTypeVariable(daoMetaData.getDAOClass(), method.getGenericReturnType());
        this.parameterTypesOfReturnType = GenericUtils.resolveTypeParameters(daoMetaData.getDAOClass(), method.getGenericReturnType());
        Annotation[][] annotations = method.getParameterAnnotations();
        this.parameterCount = annotations.length;
        this.sqlParams = new SQLParam[annotations.length];
        int shardByIndex = -1;
        ShardBy shardBy = null;
        for (int index = 0; index < annotations.length; ++index) {
            for (Annotation annotation : annotations[index]) {
                if (annotation instanceof ShardBy) {
                    if (shardByIndex >= 0) {
                        throw new IllegalArgumentException("duplicated @" + ShardBy.class.getName());
                    }
                    shardByIndex = index;
                    shardBy = (ShardBy)annotation;
                    continue;
                }
                if (!(annotation instanceof SQLParam)) continue;
                this.sqlParams[index] = (SQLParam)annotation;
            }
        }
        this.shardByIndex = shardByIndex;
        this.shardBy = shardBy;
    }

    public DAOMetaData getDAOMetaData() {
        return this.daoMetaData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getSQL() {
        return this.sql;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public SQLParam getSQLParamAt(int argIndex) {
        return this.sqlParams[argIndex];
    }

    public int getShardByIndex() {
        return this.shardByIndex;
    }

    public ShardBy getShardBy() {
        return this.shardBy;
    }

    public Class<?>[] getGenericReturnTypes() {
        return this.parameterTypesOfReturnType;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    public SQLType getSQLType() {
        return this.sqlType;
    }

    protected SQLType resolveSQLType(SQL sql) {
        SQLType sqlType = sql.type();
        if (sqlType == SQLType.AUTO_DETECT) {
            for (int i = 0; i < SELECT_PATTERNS.length; ++i) {
                if (!SELECT_PATTERNS[i].matcher(this.getSQL()).find() && !SELECT_PATTERNS[i].matcher(this.getMethod().getName()).find()) continue;
                sqlType = SQLType.READ;
                break;
            }
            if (sqlType == SQLType.AUTO_DETECT) {
                sqlType = SQLType.WRITE;
            }
        }
        return sqlType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatementMetaData) {
            StatementMetaData modifier = (StatementMetaData)obj;
            return this.daoMetaData.equals(modifier.daoMetaData) && this.method.equals(modifier.method);
        }
        return false;
    }

    public int hashCode() {
        return this.daoMetaData.hashCode() ^ this.method.hashCode();
    }

    public String toString() {
        return this.daoMetaData.getDAOClass().getName() + '#' + this.method.getName();
    }
}

