/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.paoding.rose.jade.annotation.ReturnGeneratedKeys;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.Querier;
import net.paoding.rose.jade.statement.Statement;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.StatementRuntime;
import net.paoding.rose.jade.statement.StatementRuntimeImpl;
import org.apache.commons.lang.ClassUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class JdbcStatement
implements Statement {
    private final StatementMetaData metaData;
    private final Interpreter[] interpreters;
    private final Querier querier;
    private final boolean batchUpdate;
    private final SQLType sqlType;

    public JdbcStatement(StatementMetaData statementMetaData, SQLType sqlType, Interpreter[] interpreters, Querier querier) {
        this.metaData = statementMetaData;
        this.interpreters = interpreters == null ? new Interpreter[]{} : interpreters;
        this.querier = querier;
        this.sqlType = sqlType;
        if (sqlType == SQLType.WRITE) {
            Method method = statementMetaData.getMethod();
            Class<?>[] types = method.getParameterTypes();
            Class returnType = statementMetaData.getReturnType();
            if (returnType.isPrimitive()) {
                returnType = ClassUtils.primitiveToWrapper(returnType);
            }
            if (types.length > 0 && List.class.isAssignableFrom(types[0])) {
                this.batchUpdate = true;
                if (this.metaData.getMethod().getAnnotation(ReturnGeneratedKeys.class) != null) {
                    throw new InvalidDataAccessApiUsageException("batch update method cannot return generated keys: " + method);
                }
                if (returnType != Void.TYPE && returnType != int[].class && returnType != Integer.class && returnType != Boolean.class) {
                    throw new InvalidDataAccessApiUsageException("error return type, only support type of {void,boolean,int,int[]}: " + method);
                }
            } else {
                this.batchUpdate = false;
                if (this.metaData.getMethod().getAnnotation(ReturnGeneratedKeys.class) != null) {
                    if (!Number.class.isAssignableFrom(returnType)) {
                        throw new InvalidDataAccessApiUsageException("error return type, only support numberic type for method with @ReturnGeneratedKeys:" + method);
                    }
                } else if (returnType != Void.TYPE && returnType != Boolean.class && returnType != Integer.class) {
                    throw new InvalidDataAccessApiUsageException("error return type, only support type of {void,boolean,int}:" + method);
                }
            }
        } else {
            this.batchUpdate = false;
        }
    }

    @Override
    public StatementMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Object execute(Map<String, Object> parameters) {
        if (this.batchUpdate) {
            Iterable iterable = (Iterable)parameters.get(":1");
            Iterator iterator = iterable.iterator();
            LinkedList<StatementRuntimeImpl> runtimes = new LinkedList<StatementRuntimeImpl>();
            while (iterator.hasNext()) {
                Object arg = iterator.next();
                HashMap<String, Object> clone = new HashMap<String, Object>(parameters);
                clone.put(":1", arg);
                if (this.metaData.getSQLParamAt(0) != null) {
                    clone.put(this.metaData.getSQLParamAt(0).value(), arg);
                }
                StatementRuntimeImpl runtime = new StatementRuntimeImpl(this.metaData, clone);
                for (Interpreter interpreter : this.interpreters) {
                    interpreter.interpret(runtime);
                }
                runtimes.add(runtime);
            }
            return this.querier.execute(this.sqlType, runtimes.toArray(new StatementRuntime[0]));
        }
        StatementRuntimeImpl runtime = new StatementRuntimeImpl(this.metaData, parameters);
        for (Interpreter interpreter : this.interpreters) {
            interpreter.interpret(runtime);
        }
        return this.querier.execute(this.sqlType, runtime);
    }
}

