/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class GenericUtils {
    private static final Class[] EMPTY_CLASSES = new Class[0];

    public static Class[] resolveTypeParameters(Class invocationClass, Type targetType) {
        if (targetType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)targetType).getActualTypeArguments();
            Class[] actualClasses = new Class[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                actualClasses[i] = GenericUtils.resolveTypeVariable(invocationClass, actualTypes[i]);
            }
            return actualClasses;
        }
        return EMPTY_CLASSES;
    }

    public static final Class resolveTypeVariable(Class invocationClass, Class declaringClass, String typeVarName) {
        TypeVariable typeVariable = null;
        for (TypeVariable typeParemeter : declaringClass.getTypeParameters()) {
            if (!typeParemeter.getName().equals(typeVarName)) continue;
            typeVariable = typeParemeter;
            break;
        }
        if (typeVariable == null) {
            throw new NullPointerException("not found TypeVariable name " + typeVarName);
        }
        return GenericUtils.resolveTypeVariable(invocationClass, typeVariable);
    }

    public static final Class resolveTypeVariable(Class invocationClass, Type targetType) {
        Type old;
        if (targetType == null) {
            throw new NullPointerException("TypeVariable is null");
        }
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        if (targetType instanceof ParameterizedType) {
            return GenericUtils.resolveTypeVariable(invocationClass, ((ParameterizedType)targetType).getRawType());
        }
        if (targetType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)targetType).getGenericComponentType();
            componentType = GenericUtils.resolveTypeVariable(invocationClass, componentType);
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        HashMap refs = new HashMap();
        LinkedList<Type> allSuperTypes = new LinkedList<Type>();
        allSuperTypes.addAll(Arrays.asList(invocationClass.getGenericInterfaces()));
        for (int i = 0; i < allSuperTypes.size(); ++i) {
            Type type = (Type)allSuperTypes.get(i);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class interfaceClass = (Class)parameterizedType.getRawType();
                int j = 0;
                for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                    TypeVariable v = interfaceClass.getTypeParameters()[j++];
                    refs.put(v, actualTypeArgument);
                }
                for (Type t : interfaceClass.getGenericInterfaces()) {
                    if (allSuperTypes.contains(t)) continue;
                    allSuperTypes.add(t);
                }
                continue;
            }
            for (Type t : ((Class)type).getGenericInterfaces()) {
                if (allSuperTypes.contains(t)) continue;
                allSuperTypes.add(t);
            }
        }
        Type returnType = targetType;
        do {
            old = returnType;
            if (!((returnType = (Type)refs.get(returnType)) instanceof Class)) continue;
            return (Class)returnType;
        } while (returnType != null);
        returnType = old;
        if (returnType instanceof WildcardType) {
            return (Class)((WildcardType)returnType).getUpperBounds()[0];
        }
        return (Class)((TypeVariable)returnType).getBounds()[0];
    }

    public static Map<String, ?> getConstantFrom(Class clazz, boolean findAncestor, boolean findInterfaces) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (findInterfaces) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                GenericUtils.fillConstantFrom(interfaceClass, map);
            }
        }
        if (findAncestor) {
            for (Class superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
                GenericUtils.fillConstantFrom(superClass, map);
            }
        }
        GenericUtils.fillConstantFrom(clazz, map);
        return map;
    }

    protected static void fillConstantFrom(Class clazz, HashMap<String, Object> map) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (field.isSynthetic() || !Modifier.isStatic(modifiers = field.getModifiers())) continue;
            try {
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                map.put(field.getName(), field.get(null));
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public static void main(String ... args) {
        System.out.println("\u8f93\u51fa\u6240\u6709\u5e38\u91cf");
        Map<String, ?> constants = GenericUtils.getConstantFrom(Character.class, true, true);
        System.out.println(constants);
        System.out.println();
        System.out.println("\u8f93\u51fa\u65b9\u6cd5\u7684\u8fd4\u56de\u7c7b\u578b" + ClassLoader.class.getName());
        for (Method method : ClassLoader.class.getMethods()) {
            Object[] classes = GenericUtils.resolveTypeParameters(ClassLoader.class, method.getGenericReturnType());
            System.out.print(method.getName() + " = ");
            System.out.println(Arrays.toString(classes));
        }
        System.out.println();
        System.out.println("\u8f93\u51fa\u8d85\u7c7b\u7684\u7c7b\u578b" + Properties.class.getName());
        Type genericSuperclassType = Properties.class.getGenericSuperclass();
        System.out.print(genericSuperclassType + " = ");
        System.out.println(Arrays.toString(GenericUtils.resolveTypeParameters(Properties.class, genericSuperclassType)));
        System.out.println();
        System.out.println("\u8f93\u51fa\u6d3e\u751f\u7c7b\u7684\u7c7b\u578b" + Properties.class.getName());
        for (Type genericInterfaceType : Properties.class.getGenericInterfaces()) {
            Object[] classes = GenericUtils.resolveTypeParameters(Properties.class, genericInterfaceType);
            System.out.print(genericInterfaceType + " = ");
            System.out.println(Arrays.toString(classes));
        }
    }
}

