/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement;

import java.util.Arrays;
import java.util.List;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.InterpreterComparator;
import net.paoding.rose.jade.statement.InterpreterFactory;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.SystemInterpreter;
import org.apache.commons.lang.ArrayUtils;

public class DefaultInterpreterFactory
implements InterpreterFactory {
    private Interpreter[] interpreters = new Interpreter[]{new SystemInterpreter()};

    public DefaultInterpreterFactory() {
    }

    public DefaultInterpreterFactory(Interpreter[] interpreters) {
        for (Interpreter interpreter : interpreters) {
            this.addInterpreter(interpreter);
        }
    }

    public DefaultInterpreterFactory(List<Interpreter> interpreters) {
        for (Interpreter interpreter : interpreters) {
            this.addInterpreter(interpreter);
        }
    }

    public synchronized void addInterpreter(Interpreter interpreter) {
        if (!ArrayUtils.contains((Object[])this.interpreters, (Object)interpreter)) {
            Interpreter[] interpreters = Arrays.copyOf(this.interpreters, this.interpreters.length + 1);
            interpreters[this.interpreters.length] = interpreter;
            Arrays.sort(interpreters, new InterpreterComparator());
            this.interpreters = interpreters;
        }
    }

    @Override
    public Interpreter[] getInterpreters(StatementMetaData metaData) {
        return this.interpreters;
    }
}

