/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.rowmapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.paoding.rose.jade.annotation.KeyColumnOfMap;
import net.paoding.rose.jade.rowmapper.MapEntryImpl;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class MapEntryRowMapper
implements RowMapper {
    private static Log logger = LogFactory.getLog(MapEntryRowMapper.class);
    private final RowMapper mapper;
    private String keyColumn;
    private int keyColumnIndex = 1;
    private Class<?> keyType;
    private StatementMetaData modifier;

    public MapEntryRowMapper(StatementMetaData modifier, RowMapper mapper) {
        this.modifier = modifier;
        Class<?>[] genericTypes = modifier.getGenericReturnTypes();
        if (genericTypes.length < 2) {
            throw new IllegalArgumentException("please set map generic parameters in method: " + modifier.getMethod());
        }
        KeyColumnOfMap mapKey = modifier.getAnnotation(KeyColumnOfMap.class);
        this.keyColumn = mapKey != null ? mapKey.value() : null;
        this.keyType = genericTypes[0];
        this.mapper = mapper;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object key;
        if (rowNum == 0) {
            if (StringUtils.isNotEmpty((String)this.keyColumn)) {
                this.keyColumnIndex = rs.findColumn(this.keyColumn);
                if (this.keyColumnIndex <= 0) {
                    throw new IllegalArgumentException(String.format("wrong key name %s for method: %s ", this.keyColumn, this.modifier.getMethod()));
                }
                this.keyColumn = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("keyIndex=%s; for method: %s ", this.keyColumnIndex, this.modifier.getMethod()));
            }
        }
        if ((key = JdbcUtils.getResultSetValue((ResultSet)rs, (int)this.keyColumnIndex, this.keyType)) != null && !this.keyType.isInstance(key)) {
            ResultSetMetaData rsmd = rs.getMetaData();
            throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(this.keyColumnIndex) + "' expected type is '" + this.keyType + "'");
        }
        return new MapEntryImpl<Object, Object>(key, this.mapper.mapRow(rs, rowNum));
    }
}

