/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.rowmapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.paoding.rose.jade.annotation.RowHandler;
import net.paoding.rose.jade.annotation.StatementRowMapper;
import net.paoding.rose.jade.rowmapper.ArrayRowMapper;
import net.paoding.rose.jade.rowmapper.BeanPropertyRowMapper;
import net.paoding.rose.jade.rowmapper.ListRowMapper;
import net.paoding.rose.jade.rowmapper.MapEntryColumnRowMapper;
import net.paoding.rose.jade.rowmapper.MapEntryRowMapper;
import net.paoding.rose.jade.rowmapper.RowMapperFactory;
import net.paoding.rose.jade.rowmapper.SetRowMapper;
import net.paoding.rose.jade.rowmapper.TypeUtils;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class DefaultRowMapperFactory
implements RowMapperFactory {
    private static Log logger = LogFactory.getLog(RowMapperFactory.class);
    private Map<String, RowMapper> rowMappers = new HashMap<String, RowMapper>();

    public RowMapper getRowMapper(StatementMetaData modifier) {
        Object rowMapper;
        RowHandler rowHandler = modifier.getAnnotation(RowHandler.class);
        if (rowHandler != null && rowHandler.rowMapper() != RowHandler.ByDefault.class) {
            try {
                RowMapper rowMapper2 = rowHandler.rowMapper().newInstance();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("using rowMapper " + rowMapper2 + " for " + modifier));
                }
                if (rowMapper2 instanceof StatementRowMapper) {
                    ((StatementRowMapper)rowMapper2).init(modifier);
                }
                return rowMapper2;
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(rowHandler.rowMapper(), ex.getMessage(), (Throwable)ex);
            }
        }
        Class<?> returnClassType = modifier.getMethod().getReturnType();
        Class rowType = DefaultRowMapperFactory.getRowType(modifier);
        if (rowType.isPrimitive()) {
            rowType = ClassUtils.primitiveToWrapper(rowType);
        }
        if (TypeUtils.isColumnType(rowType)) {
            rowMapper = Map.class.isAssignableFrom(returnClassType) ? new MapEntryColumnRowMapper(modifier, rowType) : new SingleColumnRowMapper(rowType);
        } else {
            if (rowType == Map.class) {
                rowMapper = new ColumnMapRowMapper();
            } else if (rowType.isArray()) {
                rowMapper = new ArrayRowMapper(rowType);
            } else if (rowType == List.class || rowType == Collection.class) {
                rowMapper = new ListRowMapper(modifier);
            } else if (rowType == Set.class) {
                rowMapper = new SetRowMapper(modifier);
            } else {
                boolean checkColumns = rowHandler == null ? true : rowHandler.checkColumns();
                boolean checkProperties = rowHandler == null ? false : rowHandler.checkProperties();
                String key = rowType.getName() + "[checkColumns=" + checkColumns + "&checkProperties=" + checkProperties + "]";
                rowMapper = this.rowMappers.get(key);
                if (rowMapper == null) {
                    rowMapper = new BeanPropertyRowMapper(rowType, checkColumns, checkProperties);
                    this.rowMappers.put(key, (RowMapper)rowMapper);
                }
            }
            if (Map.class.isAssignableFrom(returnClassType)) {
                rowMapper = new MapEntryRowMapper(modifier, (RowMapper)rowMapper);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("using rowMapper " + rowMapper + " for " + modifier));
        }
        return rowMapper;
    }

    private static Class<?> getRowType(StatementMetaData statementMetaData) {
        Class<?> returnClassType = statementMetaData.getReturnType();
        if (Collection.class.isAssignableFrom(returnClassType) || Iterable.class == returnClassType || Iterator.class == returnClassType) {
            return DefaultRowMapperFactory.getRowTypeFromCollectionType(statementMetaData, returnClassType);
        }
        if (Map.class.isAssignableFrom(returnClassType)) {
            return DefaultRowMapperFactory.getRowTypeFromMapType(statementMetaData, returnClassType);
        }
        if (returnClassType.isArray() && returnClassType != byte[].class) {
            return returnClassType.getComponentType();
        }
        return returnClassType;
    }

    private static Class<?> getRowTypeFromMapType(StatementMetaData modifier, Class<?> returnClassType) {
        Class<?>[] genericTypes = modifier.getGenericReturnTypes();
        if (genericTypes.length != 2) {
            throw new IllegalArgumentException("the returned generic type '" + returnClassType.getName() + "' should has two actual type parameters.");
        }
        Class<?> rowType = genericTypes[1];
        return rowType;
    }

    private static Class<?> getRowTypeFromCollectionType(StatementMetaData modifier, Class<?> returnClassType) {
        if (returnClassType != List.class && returnClassType != ArrayList.class && returnClassType != LinkedList.class && returnClassType != Collection.class && returnClassType != Iterable.class && returnClassType != Iterator.class && returnClassType != Set.class && returnClassType != HashSet.class) {
            throw new IllegalArgumentException("error collection type " + returnClassType.getName() + "; only support List/ArrayList/LinkedList, CollectionIterable/Iterator, Set/HashSet");
        }
        Class<?>[] genericTypes = modifier.getGenericReturnTypes();
        if (genericTypes.length != 1) {
            throw new IllegalArgumentException("the returned generic type '" + returnClassType.getName() + "' should has a actual type parameter.");
        }
        Class<?> rowType = genericTypes[0];
        return rowType;
    }
}

