/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.rowmapper;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class BeanPropertyRowMapper
implements RowMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Class<?> mappedClass;
    private Map<String, PropertyDescriptor> mappedFields;
    private final boolean checkColumns;
    private final boolean checkProperties;
    private Set<String> mappedProperties;

    public BeanPropertyRowMapper(Class<?> mappedClass, boolean checkColumns, boolean checkProperties) {
        this.mappedClass = mappedClass;
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        this.checkProperties = checkProperties;
        this.checkColumns = checkColumns;
        this.initialize();
    }

    protected void initialize() {
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(this.mappedClass);
        if (this.checkProperties) {
            this.mappedProperties = new HashSet<String>();
        }
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            if (pd.getWriteMethod() == null) continue;
            if (this.checkProperties) {
                this.mappedProperties.add(pd.getName());
            }
            this.mappedFields.put(pd.getName().toLowerCase(), pd);
            for (String underscoredName : this.underscoreName(pd.getName())) {
                if (underscoredName == null || pd.getName().toLowerCase().equals(underscoredName)) continue;
                this.mappedFields.put(underscoredName, pd);
            }
        }
    }

    private String[] underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        if (camelCaseName != null && camelCaseName.length() > 0) {
            result.append(camelCaseName.substring(0, 1).toLowerCase());
            for (int i = 1; i < camelCaseName.length(); ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(ch);
            }
        }
        String name = result.toString();
        String name2 = null;
        boolean digitFound = false;
        for (int i = name.length() - 1; i >= 0; --i) {
            if (Character.isDigit(name.charAt(i))) {
                digitFound = true;
                continue;
            }
            if (digitFound && i < name.length() - 1 && i > 0) {
                if (name2 == null) {
                    name2 = name;
                }
                name2 = name2.substring(0, i + 1) + "_" + name2.substring(i + 1);
            }
            digitFound = false;
        }
        return new String[]{name, name2};
    }

    public Object mapRow(ResultSet rs, int rowNumber) throws SQLException {
        Object mappedObject = BeanPropertyRowMapper.instantiateClass(this.mappedClass);
        BeanWrapperImpl bw = new BeanWrapperImpl(mappedObject);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        boolean warnEnabled = this.logger.isWarnEnabled();
        boolean debugEnabled = this.logger.isDebugEnabled();
        HashSet<String> populatedProperties = this.checkProperties ? new HashSet<String>() : null;
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index).toLowerCase();
            PropertyDescriptor pd = this.mappedFields.get(column);
            if (pd != null) {
                try {
                    Object value = JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, pd.getPropertyType());
                    if (debugEnabled && rowNumber == 0) {
                        this.logger.debug((Object)("Mapping column '" + column + "' to property '" + pd.getName() + "' of type " + pd.getPropertyType()));
                    }
                    bw.setPropertyValue(pd.getName(), value);
                    if (populatedProperties == null) continue;
                    populatedProperties.add(pd.getName());
                    continue;
                }
                catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + pd.getName(), (Throwable)ex);
                }
            }
            if (this.checkColumns) {
                throw new InvalidDataAccessApiUsageException("Unable to map column '" + column + "' to any properties of bean " + this.mappedClass.getName());
            }
            if (!warnEnabled || rowNumber != 0) continue;
            this.logger.warn((Object)("Unable to map column '" + column + "' to any properties of bean " + this.mappedClass.getName()));
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass + "]: " + this.mappedProperties);
        }
        return mappedObject;
    }

    private static Object instantiateClass(Class<?> clazz) throws BeanInstantiationException {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new BeanInstantiationException(clazz, ex.getMessage(), (Throwable)ex);
        }
    }
}

