/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.dataaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.paoding.rose.jade.dataaccess.DataAccess;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.KeyHolder;

public class DataAccessImpl
implements DataAccess {
    private final JdbcTemplate jdbcTemplate;

    public DataAccessImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    @Override
    public <T> List<T> select(String sql, Object[] args, RowMapper<T> rowMapper) {
        PreparedStatementCreator csc = this.getPreparedStatementCreator(sql, args, false);
        return (List)this.jdbcTemplate.query(csc, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper));
    }

    @Override
    public int update(String sql, Object[] args, KeyHolder generatedKeyHolder) {
        boolean returnKeys = generatedKeyHolder != null;
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, args, returnKeys);
        if (generatedKeyHolder == null) {
            return this.jdbcTemplate.update(psc);
        }
        return this.jdbcTemplate.update(psc, generatedKeyHolder);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }

    private PreparedStatementCreator getPreparedStatementCreator(final String sql, final Object[] args, final boolean returnKeys) {
        PreparedStatementCreator creator = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql);
                ps = returnKeys ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        Object arg = args[i];
                        if (arg instanceof SqlParameterValue) {
                            SqlParameterValue paramValue = (SqlParameterValue)arg;
                            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (SqlParameter)paramValue, (Object)paramValue.getValue());
                            continue;
                        }
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)arg);
                    }
                }
                return ps;
            }
        };
        return creator;
    }
}

