/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.dataaccess;

import java.util.Map;
import net.paoding.rose.jade.dataaccess.DataAccess;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.dataaccess.DataAccessImpl;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.DataSourceHolder;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataAccessFactoryAdapter
implements DataAccessFactory {
    protected final DataSourceFactory dataSourceFactory;

    public DataAccessFactoryAdapter(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    @Override
    public DataAccess getDataAccess(StatementMetaData metaData, Map<String, Object> runtime) {
        DataSourceHolder holder = this.dataSourceFactory.getHolder(metaData, runtime);
        while (holder != null && holder.isFactory()) {
            holder = holder.getFactory().getHolder(metaData, runtime);
        }
        if (holder == null || holder.getDataSource() == null) {
            throw new NullPointerException("cannot found a dataSource for: " + metaData);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(holder.getDataSource());
        return new DataAccessImpl(jdbcTemplate);
    }
}

