/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.paoding.rose.jade.annotation.DAO;
import net.paoding.rose.jade.dataaccess.DataSourceFactory;
import net.paoding.rose.jade.dataaccess.DataSourceHolder;
import net.paoding.rose.jade.statement.StatementMetaData;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringDataSourceFactory
implements DataSourceFactory,
ApplicationContextAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory applicationContext;
    private ConcurrentHashMap<Class<?>, DataSourceHolder> cachedDataSources = new ConcurrentHashMap();

    public SpringDataSourceFactory() {
    }

    public SpringDataSourceFactory(ListableBeanFactory applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public DataSourceHolder getHolder(StatementMetaData metaData, Map<String, Object> runtimeProperties) {
        Class<?> daoClass = metaData.getDAOMetaData().getDAOClass();
        DataSourceHolder holder = this.cachedDataSources.get(daoClass);
        if (holder != null) {
            return holder;
        }
        holder = this.getDataSourceByDirectory(daoClass, daoClass.getName());
        if (holder != null) {
            this.cachedDataSources.put(daoClass, holder);
            return holder;
        }
        String catalog = daoClass.getAnnotation(DAO.class).catalog();
        if (catalog.length() > 0) {
            holder = this.getDataSourceByDirectory(daoClass, catalog + "." + daoClass.getSimpleName());
        }
        if (holder != null) {
            this.cachedDataSources.put(daoClass, holder);
            return holder;
        }
        holder = this.getDataSourceByKey(daoClass, "jade.dataSource");
        if (holder != null) {
            this.cachedDataSources.put(daoClass, holder);
            return holder;
        }
        holder = this.getDataSourceByKey(daoClass, "dataSource");
        if (holder != null) {
            this.cachedDataSources.put(daoClass, holder);
            return holder;
        }
        return null;
    }

    private DataSourceHolder getDataSourceByDirectory(Class<?> daoClass, String catalog) {
        String tempCatalog = catalog;
        while (tempCatalog != null && tempCatalog.length() > 0) {
            DataSourceHolder dataSource = this.getDataSourceByKey(daoClass, "jade.dataSource." + tempCatalog);
            if (dataSource != null) {
                return dataSource;
            }
            int index = tempCatalog.lastIndexOf(46);
            if (index == -1) {
                tempCatalog = null;
                continue;
            }
            tempCatalog = tempCatalog.substring(0, index);
        }
        return null;
    }

    private DataSourceHolder getDataSourceByKey(Class<?> daoClass, String key) {
        if (this.applicationContext.containsBean(key)) {
            Object dataSource = this.applicationContext.getBean(key);
            if (!(dataSource instanceof DataSource) && !(dataSource instanceof DataSourceFactory)) {
                throw new IllegalClassException("expects DataSource or DataSourceFactory, but a " + dataSource.getClass().getName());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("found dataSource: " + key + " for DAO " + daoClass.getName()));
            }
            return new DataSourceHolder(dataSource);
        }
        return null;
    }
}

