/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.paoding.rose.jade.context.JadeInvocationHandler;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.rowmapper.RowMapperFactory;
import net.paoding.rose.jade.statement.DAOMetaData;
import net.paoding.rose.jade.statement.InterpreterFactory;
import net.paoding.rose.jade.statement.StatementWrapperProvider;
import net.paoding.rose.jade.statement.cached.CacheProvider;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JadeFactoryBean
implements FactoryBean,
InitializingBean {
    protected Class<?> objectType;
    protected DataAccessFactory dataAccessFactory;
    protected RowMapperFactory rowMapperFactory;
    protected InterpreterFactory interpreterFactory;
    protected CacheProvider cacheProvider;
    protected Object daoObject;
    private StatementWrapperProvider statementWrapperProvider;

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    public void setDataAccessFactory(DataAccessFactory dataAccessFactory) {
        this.dataAccessFactory = dataAccessFactory;
    }

    public DataAccessFactory getDataAccessFactory() {
        return this.dataAccessFactory;
    }

    public void setRowMapperFactory(RowMapperFactory rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }

    public RowMapperFactory getRowMapperFactory() {
        return this.rowMapperFactory;
    }

    public void setInterpreterFactory(InterpreterFactory interpreterFactory) {
        this.interpreterFactory = interpreterFactory;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public StatementWrapperProvider getStatementWrapperProvider() {
        return this.statementWrapperProvider;
    }

    public void setStatementWrapperProvider(StatementWrapperProvider statementWrapperProvider) {
        this.statementWrapperProvider = statementWrapperProvider;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)this.objectType.isInterface(), (String)("not a interface class: " + this.objectType.getName()));
        Assert.notNull((Object)this.dataAccessFactory);
        Assert.notNull((Object)this.rowMapperFactory);
        Assert.notNull((Object)this.interpreterFactory);
    }

    public Object getObject() {
        if (this.daoObject == null) {
            this.daoObject = this.createDAO();
            Assert.notNull((Object)this.daoObject);
        }
        return this.daoObject;
    }

    protected Object createDAO() {
        try {
            DAOMetaData daoMetaData = new DAOMetaData(this.objectType);
            JadeInvocationHandler handler = new JadeInvocationHandler(daoMetaData, this.interpreterFactory, this.rowMapperFactory, this.dataAccessFactory, this.cacheProvider, this.statementWrapperProvider);
            return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{this.objectType}, (InvocationHandler)handler);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("failed to create bean for " + this.objectType.getName(), e);
        }
    }
}

