/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context.spring;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.paoding.rose.jade.context.spring.JadeComponentProvider;
import net.paoding.rose.jade.context.spring.JadeFactoryBean;
import net.paoding.rose.jade.context.spring.SpringDataSourceFactoryDelegate;
import net.paoding.rose.jade.context.spring.SpringInterpreterFactory;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.dataaccess.DataAccessFactoryAdapter;
import net.paoding.rose.jade.rowmapper.DefaultRowMapperFactory;
import net.paoding.rose.jade.rowmapper.RowMapperFactory;
import net.paoding.rose.jade.statement.InterpreterFactory;
import net.paoding.rose.jade.statement.StatementWrapperProvider;
import net.paoding.rose.jade.statement.cached.CacheProvider;
import net.paoding.rose.load.ResourceRef;
import net.paoding.rose.load.RoseScanner;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;

public class JadeBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String propertyPrefix = "jade.context.spring";
    private final Log logger = LogFactory.getLog(JadeBeanFactoryPostProcessor.class);
    private DataAccessFactory dataAccessFactory;
    private RowMapperFactory rowMapperFactory;
    private InterpreterFactory interpreterFactory;
    private String statmentWrapperProviderName;
    private String cacheProviderName;

    public DataAccessFactory getDataAccessFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.dataAccessFactory == null) {
            this.dataAccessFactory = new DataAccessFactoryAdapter(new SpringDataSourceFactoryDelegate((ListableBeanFactory)beanFactory));
        }
        return this.dataAccessFactory;
    }

    public InterpreterFactory getInterpreterFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.interpreterFactory == null) {
            this.interpreterFactory = new SpringInterpreterFactory((ListableBeanFactory)beanFactory);
        }
        return this.interpreterFactory;
    }

    public RowMapperFactory getRowMapperFactory() {
        if (this.rowMapperFactory == null) {
            this.rowMapperFactory = new DefaultRowMapperFactory();
        }
        return this.rowMapperFactory;
    }

    public void setRowMapperFactory(RowMapperFactory rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }

    public String getCacheProviderName(ConfigurableListableBeanFactory beanFactory) {
        if (this.cacheProviderName == null) {
            Object[] names = beanFactory.getBeanNamesForType(CacheProvider.class);
            if (names.length == 0) {
                this.cacheProviderName = "none";
            } else if (names.length == 1) {
                this.cacheProviderName = names[0];
            } else {
                String topPriority = "jade.cacheProvider";
                if (ArrayUtils.contains((Object[])names, (Object)topPriority)) {
                    this.cacheProviderName = topPriority;
                } else {
                    throw new IllegalStateException("required not more than 1 CacheProvider, but found " + names.length);
                }
            }
        }
        return "none".equals(this.cacheProviderName) ? null : this.cacheProviderName;
    }

    public String getStatementWrapperProvider(ConfigurableListableBeanFactory beanFactory) {
        if (this.statmentWrapperProviderName == null) {
            Object[] names = beanFactory.getBeanNamesForType(StatementWrapperProvider.class);
            if (names.length == 0) {
                this.statmentWrapperProviderName = "none";
            } else if (names.length == 1) {
                this.statmentWrapperProviderName = names[0];
            } else {
                String topPriority = "jade.statmentWrapperProvider";
                if (ArrayUtils.contains((Object[])names, (Object)topPriority)) {
                    this.statmentWrapperProviderName = topPriority;
                } else {
                    throw new IllegalStateException("required not more than 1 StatmentWrapperProvider, but found " + names.length);
                }
            }
        }
        return "none".equals(this.statmentWrapperProviderName) ? null : this.statmentWrapperProviderName;
    }

    public final void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String springFlag = System.getProperty(propertyPrefix);
        if (springFlag != null && springFlag.length() > 0) {
            this.logger.info((Object)("found jade.context.spring=" + springFlag));
            return;
        }
        this.doPostProcessBeanFactory(beanFactory);
    }

    private void doPostProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[jade] starting ...");
        }
        List<ResourceRef> resources = this.findRoseResources();
        List<String> urls = this.findJadeResources(resources);
        this.findJadeDAODefinitions(beanFactory, urls);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[jade] exits");
        }
    }

    private List<ResourceRef> findRoseResources() {
        List resources;
        try {
            resources = RoseScanner.getInstance().getJarOrClassesFolderResources();
        }
        catch (IOException e) {
            throw new ApplicationContextException("error on getJarResources/getClassesFolderResources", (Throwable)e);
        }
        return resources;
    }

    private List<String> findJadeResources(List<ResourceRef> resources) {
        LinkedList<String> urls = new LinkedList<String>();
        for (ResourceRef ref : resources) {
            if (!ref.hasModifier("dao") && !ref.hasModifier("DAO")) continue;
            try {
                Resource resource = ref.getResource();
                File resourceFile = resource.getFile();
                if (resourceFile.isFile()) {
                    urls.add("jar:file:" + resourceFile.toURI().getPath() + "!/");
                    continue;
                }
                if (!resourceFile.isDirectory()) continue;
                urls.add(resourceFile.toURI().toString());
            }
            catch (IOException e) {
                throw new ApplicationContextException("error on resource.getFile", (Throwable)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[jade] found " + urls.size() + " jade urls: " + urls));
        }
        return urls;
    }

    private void findJadeDAODefinitions(ConfigurableListableBeanFactory beanFactory, List<String> urls) {
        JadeComponentProvider provider = new JadeComponentProvider();
        HashSet<String> daoClassNames = new HashSet<String>();
        for (String url : urls) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[jade] call 'jade/find'");
            }
            Set<BeanDefinition> dfs = provider.findCandidateComponents(url);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("[jade] found " + dfs.size() + " beanDefinition from '" + url + "'"));
            }
            for (BeanDefinition beanDefinition : dfs) {
                String daoClassName = beanDefinition.getBeanClassName();
                if (this.getDisableFlag(daoClassName)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[jade] ignored disabled jade dao class: " + daoClassName + "  [" + url + "]"));
                    continue;
                }
                if (daoClassNames.contains(daoClassName)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[jade] ignored replicated jade dao class: " + daoClassName + "  [" + url + "]"));
                    continue;
                }
                daoClassNames.add(daoClassName);
                this.registerDAODefinition(beanFactory, beanDefinition);
            }
        }
    }

    private void registerDAODefinition(ConfigurableListableBeanFactory beanFactory, BeanDefinition beanDefinition) {
        String statementWrapperProvider;
        String daoClassName = beanDefinition.getBeanClassName();
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        propertyValues.addPropertyValue("objectType", (Object)daoClassName);
        propertyValues.addPropertyValue("dataAccessFactory", (Object)this.getDataAccessFactory(beanFactory));
        propertyValues.addPropertyValue("rowMapperFactory", (Object)this.getRowMapperFactory());
        propertyValues.addPropertyValue("interpreterFactory", (Object)this.getInterpreterFactory(beanFactory));
        String cacheProviderName = this.getCacheProviderName(beanFactory);
        if (cacheProviderName != null) {
            RuntimeBeanReference beanRef = new RuntimeBeanReference(cacheProviderName);
            propertyValues.addPropertyValue("cacheProvider", (Object)beanRef);
        }
        if ((statementWrapperProvider = this.getStatementWrapperProvider(beanFactory)) != null) {
            RuntimeBeanReference beanRef = new RuntimeBeanReference(statementWrapperProvider);
            propertyValues.addPropertyValue("statementWrapperProvider", (Object)beanRef);
        }
        ScannedGenericBeanDefinition scannedBeanDefinition = (ScannedGenericBeanDefinition)beanDefinition;
        scannedBeanDefinition.setPropertyValues(propertyValues);
        scannedBeanDefinition.setBeanClass(JadeFactoryBean.class);
        DefaultListableBeanFactory defaultBeanFactory = (DefaultListableBeanFactory)beanFactory;
        defaultBeanFactory.registerBeanDefinition(daoClassName, beanDefinition);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[jade] register DAO: " + daoClassName));
        }
    }

    protected boolean getDisableFlag(String daoType) {
        String flag;
        String name = daoType;
        while ((flag = name.length() == 0 ? System.getProperty("jade.context.spring.*") : System.getProperty("jade.context.spring." + name)) == null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                if (name.length() == 0) {
                    return false;
                }
                name = "";
                continue;
            }
            name = name.substring(0, index);
        }
        if ("0".equals(flag)) {
            return true;
        }
        if (flag == null || "1".equals(flag)) {
            return false;
        }
        if (name.length() == 0) {
            name = "*";
        }
        throw new IllegalArgumentException("illegal value of property: jade.context.spring." + name + "='" + flag + "'");
    }
}

