/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.paoding.rose.jade.annotation.DAO;
import net.paoding.rose.jade.annotation.SQLParam;
import net.paoding.rose.jade.annotation.SQLType;
import net.paoding.rose.jade.dataaccess.DataAccessFactory;
import net.paoding.rose.jade.rowmapper.RowMapperFactory;
import net.paoding.rose.jade.statement.DAOMetaData;
import net.paoding.rose.jade.statement.Interpreter;
import net.paoding.rose.jade.statement.InterpreterFactory;
import net.paoding.rose.jade.statement.JdbcStatement;
import net.paoding.rose.jade.statement.Querier;
import net.paoding.rose.jade.statement.SelectQuerier;
import net.paoding.rose.jade.statement.Statement;
import net.paoding.rose.jade.statement.StatementMetaData;
import net.paoding.rose.jade.statement.StatementWrapperProvider;
import net.paoding.rose.jade.statement.UpdateQuerier;
import net.paoding.rose.jade.statement.cached.CacheProvider;
import net.paoding.rose.jade.statement.cached.CachedStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.RowMapper;

public class JadeInvocationHandler
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(JadeInvocationHandler.class);
    private final ConcurrentHashMap<Method, Statement> statements = new ConcurrentHashMap();
    private final DAOMetaData daoMetaData;
    private final DataAccessFactory dataAccessFactory;
    private final RowMapperFactory rowMapperFactory;
    private final InterpreterFactory interpreterFactory;
    private final CacheProvider cacheProvider;
    private final StatementWrapperProvider statementWrapperProvider;
    private static final String[] INDEX_NAMES = new String[]{":1", ":2", ":3", ":4", ":5", ":6", ":7", ":8", ":9", ":10", ":11", ":12", ":13", ":14", ":15", ":16", ":17", ":18", ":19", ":20", ":21", ":22", ":23", ":24", ":25", ":26", ":27", ":28", ":29", ":30"};

    public JadeInvocationHandler(DAOMetaData daoMetaData, InterpreterFactory interpreterFactory, RowMapperFactory rowMapperFactory, DataAccessFactory dataAccessFactory, CacheProvider cacheProvider, StatementWrapperProvider statementWrapperProvider) {
        this.daoMetaData = daoMetaData;
        this.rowMapperFactory = rowMapperFactory;
        this.dataAccessFactory = dataAccessFactory;
        this.interpreterFactory = interpreterFactory;
        this.cacheProvider = cacheProvider;
        this.statementWrapperProvider = statementWrapperProvider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HashMap<String, Object> parameters;
        boolean debugEnabled = logger.isDebugEnabled();
        if (debugEnabled) {
            logger.debug((Object)("invoking " + this.daoMetaData.getDAOClass().getName() + "#" + method.getName()));
        }
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        Statement statement = this.getStatement(method);
        StatementMetaData statemenetMetaData = statement.getMetaData();
        if (args == null || args.length == 0) {
            parameters = new HashMap<String, Object>(4);
        } else {
            parameters = new HashMap(args.length * 2 + 4);
            for (int i = 0; i < args.length; ++i) {
                parameters.put(INDEX_NAMES[i], args[i]);
                SQLParam sqlParam = statemenetMetaData.getSQLParamAt(i);
                if (sqlParam == null) continue;
                parameters.put(sqlParam.value(), args[i]);
            }
        }
        StringBuilder invocationInfo = null;
        if (debugEnabled) {
            invocationInfo = this.getInvocationInfo(statemenetMetaData, parameters);
            logger.debug((Object)("invoking " + invocationInfo.toString()));
        }
        long begin = System.currentTimeMillis();
        Object result = statement.execute(parameters);
        long cost = System.currentTimeMillis() - begin;
        if (logger.isInfoEnabled()) {
            if (invocationInfo == null) {
                invocationInfo = this.getInvocationInfo(statemenetMetaData, parameters);
            }
            logger.info((Object)("cost " + cost + "ms: " + invocationInfo));
        }
        return result;
    }

    private StringBuilder getInvocationInfo(StatementMetaData metaData, Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(metaData).append("\n");
        sb.append("\tsql: ").append(metaData.getSQL()).append("\n");
        sb.append("\tparameters: ");
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key).append("='").append(parameters.get(key)).append("'  ");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement getStatement(Method method) {
        Statement statement = this.statements.get(method);
        if (statement == null) {
            Method method2 = method;
            synchronized (method2) {
                statement = this.statements.get(method);
                if (statement == null) {
                    Querier querier;
                    StatementMetaData smd = new StatementMetaData(this.daoMetaData, method);
                    SQLType sqlType = smd.getSQLType();
                    if (sqlType == SQLType.READ) {
                        RowMapper<?> rowMapper = this.rowMapperFactory.getRowMapper(smd);
                        querier = new SelectQuerier(this.dataAccessFactory, smd, rowMapper);
                    } else {
                        querier = new UpdateQuerier(this.dataAccessFactory, smd);
                    }
                    Interpreter[] interpreters = this.interpreterFactory.getInterpreters(smd);
                    statement = new JdbcStatement(smd, sqlType, interpreters, querier);
                    if (this.cacheProvider != null) {
                        statement = new CachedStatement(this.cacheProvider, statement);
                    }
                    this.statements.put(method, this.wrap(statement));
                }
            }
        }
        return statement;
    }

    private Statement wrap(Statement statement) {
        if (this.statementWrapperProvider != null) {
            return this.statementWrapperProvider.wrap(statement);
        }
        return statement;
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) throws CloneNotSupportedException {
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("hashCode")) {
            return this.daoMetaData.getDAOClass().hashCode() * 13 + this.hashCode();
        }
        if (methodName.equals("equals")) {
            return args[0] == proxy;
        }
        if (methodName.equals("clone")) {
            throw new CloneNotSupportedException("clone is not supported for jade dao.");
        }
        throw new UnsupportedOperationException(this.daoMetaData.getDAOClass().getName() + "#" + method.getName());
    }

    public String toString() {
        DAO dao = this.daoMetaData.getDAOClass().getAnnotation(DAO.class);
        String toString = this.daoMetaData.getDAOClass().getName() + "[catalog=" + dao.catalog() + "]";
        return toString;
    }
}

