/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.lettuce.LettuceByteCodec;

public class LettuceHashCache
implements Level2Cache {
    private static final LettuceByteCodec codec = new LettuceByteCodec();
    private String namespace;
    private String region;
    private RedisClient client;

    public LettuceHashCache(String namespace, String region, RedisClient client) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.client = client;
        this.namespace = namespace;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.trim().isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    @Override
    public byte[] getBytes(String key) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            byte[] byArray = (byte[])cmd.hget((Object)this.region, (Object)key);
            return byArray;
        }
    }

    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            List<byte[]> list = cmd.hmget((Object)this.region, (Object[])keys.stream().toArray(String[]::new)).stream().map(kv -> (byte[])kv.getValue()).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.hset((Object)this.region, (Object)key, (Object)bytes);
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.hmset((Object)this.region, bytes);
        }
    }

    @Override
    public Collection<String> keys() {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            List list = cmd.hkeys((Object)this.region);
            return list;
        }
    }

    @Override
    public void evict(String ... keys) {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.hdel((Object)this.region, (Object[])keys);
        }
    }

    @Override
    public void clear() {
        try (StatefulRedisConnection connection = this.client.connect((RedisCodec)codec);){
            RedisCommands cmd = connection.sync();
            cmd.del((Object[])new String[]{this.region});
        }
    }
}

