/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.Level1Cache;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.NullObject;

public abstract class CacheChannel
implements Closeable,
AutoCloseable {
    private static final Map<String, Object> _g_keyLocks = new ConcurrentHashMap<String, Object>();
    private J2CacheConfig config;
    private boolean defaultCacheNullObject;

    public CacheChannel(J2CacheConfig config) {
        this.config = config;
        this.defaultCacheNullObject = config.isDefaultCacheNullObject();
    }

    private NullObject newNullObject() {
        return new NullObject();
    }

    protected abstract void sendClearCmd(String var1);

    protected abstract void sendEvictCmd(String var1, String ... var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject get(String region, String key, boolean ... cacheNullObject) {
        CacheObject obj = new CacheObject(region, key, 1);
        obj.setValue(CacheProviderHolder.getLevel1Cache(region).get(key));
        if (obj.rawValue() != null) {
            return obj;
        }
        String lock_key = key + '%' + region;
        Object object = _g_keyLocks.computeIfAbsent(lock_key, v -> new Object());
        synchronized (object) {
            obj.setValue(CacheProviderHolder.getLevel1Cache(region).get(key));
            if (obj.rawValue() != null) {
                return obj;
            }
            try {
                obj.setLevel((byte)2);
                obj.setValue(CacheProviderHolder.getLevel2Cache(region).get(key));
                if (obj.rawValue() != null) {
                    CacheProviderHolder.getLevel1Cache(region).put(key, obj.rawValue());
                } else {
                    boolean cacheNull;
                    boolean bl = cacheNull = cacheNullObject.length > 0 ? cacheNullObject[0] : this.defaultCacheNullObject;
                    if (cacheNull) {
                        this.set(region, key, (Object)this.newNullObject(), true);
                    }
                }
            }
            finally {
                _g_keyLocks.remove(lock_key);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject get(String region, String key, Function<String, Object> loader, boolean ... cacheNullObject) {
        CacheObject cache = this.get(region, key, false);
        if (cache.rawValue() != null) {
            return cache;
        }
        String lock_key = key + '@' + region;
        Object object = _g_keyLocks.computeIfAbsent(lock_key, v -> new Object());
        synchronized (object) {
            cache = this.get(region, key, false);
            if (cache.rawValue() != null) {
                return cache;
            }
            try {
                Object obj = loader.apply(key);
                boolean cacheNull = cacheNullObject.length > 0 ? cacheNullObject[0] : this.defaultCacheNullObject;
                this.set(region, key, obj, cacheNull);
                cache = new CacheObject(region, key, 3, obj);
            }
            finally {
                _g_keyLocks.remove(lock_key);
            }
        }
        return cache;
    }

    public Map<String, CacheObject> get(String region, Collection<String> keys) {
        Map<String, Object> objs = CacheProviderHolder.getLevel1Cache(region).get(keys);
        List<String> level2Keys = keys.stream().filter(k -> !objs.containsKey(k) || objs.get(k) == null).collect(Collectors.toList());
        Map<String, CacheObject> results = objs.entrySet().stream().filter(p -> p.getValue() != null).collect(Collectors.toMap(p -> (String)p.getKey(), p -> new CacheObject(region, (String)p.getKey(), 1, p.getValue())));
        Map<String, Object> objs_level2 = CacheProviderHolder.getLevel2Cache(region).get(level2Keys);
        objs_level2.forEach((k, v) -> {
            results.put((String)k, new CacheObject(region, (String)k, 2, v));
            if (v != null) {
                CacheProviderHolder.getLevel1Cache(region).put((String)k, v);
            }
        });
        return results;
    }

    public Map<String, CacheObject> get(String region, Collection<String> keys, Function<String, Object> loader, boolean ... cacheNullObject) {
        Map<String, CacheObject> results = this.get(region, keys);
        results.entrySet().stream().filter(e -> ((CacheObject)e.getValue()).rawValue() == null).forEach(e -> {
            String lock_key = (String)e.getKey() + '@' + region;
            Object object = _g_keyLocks.computeIfAbsent(lock_key, v -> new Object());
            synchronized (object) {
                CacheObject cache = this.get(region, (String)e.getKey(), false);
                if (cache.rawValue() == null) {
                    try {
                        Object obj = loader.apply((String)e.getKey());
                        boolean cacheNull = cacheNullObject.length > 0 ? cacheNullObject[0] : this.defaultCacheNullObject;
                        this.set(region, (String)e.getKey(), obj, cacheNull);
                        ((CacheObject)e.getValue()).setValue(obj);
                        ((CacheObject)e.getValue()).setLevel((byte)3);
                    }
                    finally {
                        _g_keyLocks.remove(lock_key);
                    }
                } else {
                    e.setValue(cache);
                }
            }
        });
        return results;
    }

    public boolean exists(String region, String key) {
        return this.check(region, key) > 0;
    }

    public int check(String region, String key) {
        if (CacheProviderHolder.getLevel1Cache(region).exists(key)) {
            return 1;
        }
        if (CacheProviderHolder.getLevel2Cache(region).exists(key)) {
            return 2;
        }
        return 0;
    }

    public void set(String region, String key, Object value) {
        this.set(region, key, value, this.defaultCacheNullObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String region, String key, Object value, boolean cacheNullObject) {
        block4: {
            if (!cacheNullObject && value == null) {
                return;
            }
            try {
                Level1Cache level1 = CacheProviderHolder.getLevel1Cache(region);
                level1.put(key, value == null && cacheNullObject ? this.newNullObject() : value);
                Level2Cache level2 = CacheProviderHolder.getLevel2Cache(region);
                if (this.config.isSyncTtlToRedis()) {
                    level2.put(key, value == null && cacheNullObject ? this.newNullObject() : value, level1.ttl());
                    break block4;
                }
                level2.put(key, value == null && cacheNullObject ? this.newNullObject() : value);
            }
            catch (Throwable throwable) {
                this.sendEvictCmd(region, key);
                throw throwable;
            }
        }
        this.sendEvictCmd(region, key);
    }

    public void set(String region, String key, Object value, long timeToLiveInSeconds) {
        this.set(region, key, value, timeToLiveInSeconds, this.defaultCacheNullObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String region, String key, Object value, long timeToLiveInSeconds, boolean cacheNullObject) {
        block5: {
            if (!cacheNullObject && value == null) {
                return;
            }
            if (timeToLiveInSeconds <= 0L) {
                this.set(region, key, value, cacheNullObject);
                return;
            }
            try {
                CacheProviderHolder.getLevel1Cache(region, timeToLiveInSeconds).put(key, value == null && cacheNullObject ? this.newNullObject() : value);
                Level2Cache level2 = CacheProviderHolder.getLevel2Cache(region);
                if (this.config.isSyncTtlToRedis()) {
                    level2.put(key, value == null && cacheNullObject ? this.newNullObject() : value, timeToLiveInSeconds);
                    break block5;
                }
                level2.put(key, value == null && cacheNullObject ? this.newNullObject() : value);
            }
            catch (Throwable throwable) {
                this.sendEvictCmd(region, key);
                throw throwable;
            }
        }
        this.sendEvictCmd(region, key);
    }

    public void set(String region, Map<String, Object> elements) {
        this.set(region, elements, this.defaultCacheNullObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String region, Map<String, Object> elements, boolean cacheNullObject) {
        try {
            if (cacheNullObject && elements.containsValue(null)) {
                HashMap<String, Object> newElems = new HashMap<String, Object>();
                newElems.putAll(elements);
                newElems.forEach((k, v) -> {
                    if (v == null) {
                        newElems.put((String)k, this.newNullObject());
                    }
                });
                Level1Cache level1 = CacheProviderHolder.getLevel1Cache(region);
                level1.put(newElems);
                if (this.config.isSyncTtlToRedis()) {
                    CacheProviderHolder.getLevel2Cache(region).put(newElems, level1.ttl());
                } else {
                    CacheProviderHolder.getLevel2Cache(region).put(newElems);
                }
            } else {
                Level1Cache level1 = CacheProviderHolder.getLevel1Cache(region);
                level1.put(elements);
                if (this.config.isSyncTtlToRedis()) {
                    CacheProviderHolder.getLevel2Cache(region).put(elements, level1.ttl());
                } else {
                    CacheProviderHolder.getLevel2Cache(region).put(elements);
                }
            }
        }
        finally {
            this.sendEvictCmd(region, (String[])elements.keySet().stream().toArray(String[]::new));
        }
    }

    public void set(String region, Map<String, Object> elements, long timeToLiveInSeconds) {
        this.set(region, elements, timeToLiveInSeconds, this.defaultCacheNullObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String region, Map<String, Object> elements, long timeToLiveInSeconds, boolean cacheNullObject) {
        if (timeToLiveInSeconds <= 0L) {
            this.set(region, elements, cacheNullObject);
        } else {
            try {
                if (cacheNullObject && elements.containsValue(null)) {
                    HashMap<String, Object> newElems = new HashMap<String, Object>();
                    newElems.putAll(elements);
                    newElems.forEach((k, v) -> {
                        if (v == null) {
                            newElems.put((String)k, this.newNullObject());
                        }
                    });
                    CacheProviderHolder.getLevel1Cache(region, timeToLiveInSeconds).put(newElems);
                    if (this.config.isSyncTtlToRedis()) {
                        CacheProviderHolder.getLevel2Cache(region).put(newElems, timeToLiveInSeconds);
                    } else {
                        CacheProviderHolder.getLevel2Cache(region).put(newElems);
                    }
                } else {
                    CacheProviderHolder.getLevel1Cache(region, timeToLiveInSeconds).put(elements);
                    if (this.config.isSyncTtlToRedis()) {
                        CacheProviderHolder.getLevel2Cache(region).put(elements, timeToLiveInSeconds);
                    } else {
                        CacheProviderHolder.getLevel2Cache(region).put(elements);
                    }
                }
            }
            finally {
                this.sendEvictCmd(region, (String[])elements.keySet().stream().toArray(String[]::new));
            }
        }
    }

    public void evict(String region, String ... keys) {
        try {
            CacheProviderHolder.getLevel2Cache(region).evict(keys);
            CacheProviderHolder.getLevel1Cache(region).evict(keys);
        }
        finally {
            this.sendEvictCmd(region, keys);
        }
    }

    public void clear(String region) {
        try {
            CacheProviderHolder.getLevel2Cache(region).clear();
            CacheProviderHolder.getLevel1Cache(region).clear();
        }
        finally {
            this.sendClearCmd(region);
        }
    }

    public Collection<Region> regions() {
        return CacheProviderHolder.regions();
    }

    public void removeRegion(String region) {
        CacheProviderHolder.getL1Provider().removeCache(region);
    }

    public Collection<String> keys(String region) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(CacheProviderHolder.getLevel1Cache(region).keys());
        keys.addAll(CacheProviderHolder.getLevel2Cache(region).keys());
        return keys;
    }

    @Override
    public abstract void close();

    public CacheProvider getL1Provider() {
        return CacheProviderHolder.getL1Provider();
    }

    public CacheProvider getL2Provider() {
        return CacheProviderHolder.getL2Provider();
    }

    public static class Region {
        private String name;
        private long size;
        private long ttl;

        public Region(String name, long size, long ttl) {
            this.name = name;
            this.size = size;
            this.ttl = ttl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public String toString() {
            return String.format("[%s,size:%d,ttl:%d]", this.name, this.size, this.ttl);
        }
    }
}

