/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.ehcache.EhCache3;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider3
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheProvider3.class);
    private static final String DEFAULT_TPL = "default";
    private CacheManager manager;
    private ConcurrentHashMap<String, EhCache3> caches = new ConcurrentHashMap();
    private long defaultHeapSize = 1000L;

    @Override
    public String name() {
        return "ehcache3";
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        ArrayList<CacheChannel.Region> regions = new ArrayList<CacheChannel.Region>();
        this.caches.forEach((k, c) -> regions.add(new CacheChannel.Region((String)k, c.size(), c.ttl())));
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EhCache3 buildCache(String region, CacheExpiredListener listener) {
        EhCache3 ehcache = this.caches.get(region);
        if (ehcache != null) return ehcache;
        Class<EhCacheProvider3> clazz = EhCacheProvider3.class;
        synchronized (EhCacheProvider3.class) {
            ehcache = this.caches.get(region);
            if (ehcache != null) return ehcache;
            Cache cache = this.manager.getCache(region, String.class, Serializable.class);
            if (cache == null) {
                CacheConfiguration defaultCacheConfig = (CacheConfiguration)this.manager.getRuntimeConfiguration().getCacheConfigurations().get(DEFAULT_TPL);
                CacheConfiguration cacheCfg = CacheConfigurationBuilder.newCacheConfigurationBuilder((CacheConfiguration)defaultCacheConfig).build();
                cache = this.manager.createCache(region, cacheCfg);
                log.info("Could not find configuration [" + region + "]; using defaults.");
            }
            ehcache = new EhCache3(region, (Cache<String, Object>)cache, listener);
            this.caches.put(region, ehcache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ehcache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EhCache3 buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        EhCache3 ehcache = this.caches.get(region);
        if (ehcache == null) {
            Class<EhCacheProvider3> clazz = EhCacheProvider3.class;
            synchronized (EhCacheProvider3.class) {
                ehcache = this.caches.get(region);
                if (ehcache == null) {
                    CacheConfiguration conf = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)this.defaultHeapSize)).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)timeToLiveInSeconds, (TimeUnit)TimeUnit.SECONDS))).build();
                    Cache cache = this.manager.createCache(region, conf);
                    ehcache = new EhCache3(region, (Cache<String, Object>)cache, listener);
                    this.caches.put(region, ehcache);
                    log.info(String.format("Started Ehcache region [%s] with TTL: %d", region, timeToLiveInSeconds));
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        } else if (ehcache.ttl() != timeToLiveInSeconds) {
            throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, ehcache.ttl(), timeToLiveInSeconds));
        }
        return ehcache;
    }

    @Override
    public void start(Properties props) {
        String sDefaultHeapSize = props.getProperty("defaultHeapSize");
        try {
            this.defaultHeapSize = Long.parseLong(sDefaultHeapSize);
        }
        catch (Exception e) {
            log.warn(String.format("Failed to read ehcache3.defaultHeapSize = %s , use default %d", sDefaultHeapSize, this.defaultHeapSize));
        }
        String configXml = props.getProperty("configXml");
        if (configXml == null || configXml.trim().length() == 0) {
            configXml = "/ehcache3.xml";
        }
        URL myUrl = this.getClass().getResource(configXml);
        XmlConfiguration xmlConfig = new XmlConfiguration(myUrl);
        this.manager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfig);
        this.manager.init();
    }

    @Override
    public void stop() {
        if (this.manager != null) {
            this.manager.close();
            this.caches.clear();
            this.manager = null;
        }
    }
}

