/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.ehcache.EhCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EhCacheProvider.class);
    public static final String KEY_EHCACHE_NAME = "name";
    public static final String KEY_EHCACHE_CONFIG_XML = "configXml";
    private CacheManager manager;
    private ConcurrentHashMap<String, EhCache> caches;

    @Override
    public String name() {
        return "ehcache";
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        ArrayList<CacheChannel.Region> regions = new ArrayList<CacheChannel.Region>();
        this.caches.forEach((k, c) -> regions.add(new CacheChannel.Region((String)k, c.size(), c.ttl())));
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EhCache buildCache(String regionName, CacheExpiredListener listener) {
        EhCache ehcache = this.caches.get(regionName);
        if (ehcache != null) return ehcache;
        Class<EhCacheProvider> clazz = EhCacheProvider.class;
        synchronized (EhCacheProvider.class) {
            ehcache = this.caches.get(regionName);
            if (ehcache != null) return ehcache;
            Cache cache = this.manager.getCache(regionName);
            if (cache == null) {
                log.warn("Could not find configuration [" + regionName + "]; using defaults.");
                this.manager.addCache(regionName);
                cache = this.manager.getCache(regionName);
                log.info("started Ehcache region: " + regionName);
            }
            ehcache = new EhCache(cache, listener);
            this.caches.put(regionName, ehcache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ehcache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EhCache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        EhCache ehcache = this.caches.get(region);
        if (ehcache == null) {
            Class<EhCacheProvider> clazz = EhCacheProvider.class;
            synchronized (EhCacheProvider.class) {
                ehcache = this.caches.get(region);
                if (ehcache == null) {
                    CacheConfiguration cfg = this.manager.getConfiguration().getDefaultCacheConfiguration().clone();
                    cfg.setName(region);
                    if (timeToLiveInSeconds > 0L) {
                        cfg.setTimeToLiveSeconds(timeToLiveInSeconds);
                        cfg.setTimeToIdleSeconds(timeToLiveInSeconds);
                    }
                    Cache cache = new Cache(cfg);
                    this.manager.addCache(cache);
                    ehcache = new EhCache(cache, listener);
                    this.caches.put(region, ehcache);
                    log.info(String.format("Started Ehcache region [%s] with TTL: %d", region, timeToLiveInSeconds));
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        } else if (ehcache.ttl() != timeToLiveInSeconds) {
            throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, ehcache.ttl(), timeToLiveInSeconds));
        }
        return ehcache;
    }

    @Override
    public void start(Properties props) {
        if (this.manager != null) {
            log.warn("Attempt to restart an already started EhCacheProvider.");
            return;
        }
        String ehcacheName = (String)props.get(KEY_EHCACHE_NAME);
        if (ehcacheName != null && ehcacheName.trim().length() > 0) {
            this.manager = CacheManager.getCacheManager((String)ehcacheName);
        }
        if (this.manager == null) {
            if (props.containsKey(KEY_EHCACHE_CONFIG_XML)) {
                URL url = this.getClass().getResource(props.getProperty(KEY_EHCACHE_CONFIG_XML));
                this.manager = CacheManager.newInstance((URL)url);
            } else {
                this.manager = CacheManager.getInstance();
            }
        }
        this.caches = new ConcurrentHashMap();
    }

    @Override
    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.caches.clear();
            this.manager = null;
        }
    }
}

