/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.util.Serializer;

public class KryoPoolSerializer
implements Serializer {
    @Override
    public String name() {
        return "kryo_pool_ser";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        KryoHolder kryoHolder = null;
        if (obj == null) {
            throw new CacheException("obj can not be null");
        }
        try {
            kryoHolder = KryoPoolImpl.getInstance().get();
            kryoHolder.output.clear();
            kryoHolder.kryo.writeClassAndObject(kryoHolder.output, obj);
            byte[] byArray = kryoHolder.output.toBytes();
            return byArray;
        }
        catch (CacheException e) {
            throw new CacheException("Serialize obj exception");
        }
        finally {
            KryoPoolImpl.getInstance().offer(kryoHolder);
            obj = null;
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        KryoHolder kryoHolder = null;
        if (bytes == null) {
            throw new CacheException("bytes can not be null");
        }
        try {
            kryoHolder = KryoPoolImpl.getInstance().get();
            kryoHolder.input.setBuffer(bytes, 0, bytes.length);
            Object object = kryoHolder.kryo.readClassAndObject(kryoHolder.input);
            return object;
        }
        catch (CacheException e) {
            throw new CacheException("Deserialize bytes exception");
        }
        finally {
            KryoPoolImpl.getInstance().offer(kryoHolder);
            bytes = null;
        }
    }

    public static class KryoPoolImpl
    implements KryoPool {
        private final Deque<KryoHolder> kryoHolderDeque = new ConcurrentLinkedDeque<KryoHolder>();

        private KryoPoolImpl() {
        }

        public static KryoPool getInstance() {
            return Singleton.pool;
        }

        @Override
        public KryoHolder get() {
            KryoHolder kryoHolder = this.kryoHolderDeque.pollFirst();
            return kryoHolder == null ? this.creatInstnce() : kryoHolder;
        }

        public KryoHolder creatInstnce() {
            Kryo kryo = new Kryo();
            kryo.setReferences(false);
            return new KryoHolder(kryo);
        }

        @Override
        public void offer(KryoHolder kryoHolder) {
            this.kryoHolderDeque.addLast(kryoHolder);
        }

        private static class Singleton {
            private static final KryoPool pool = new KryoPoolImpl();

            private Singleton() {
            }
        }
    }

    static interface KryoPool {
        public KryoHolder get();

        public void offer(KryoHolder var1);
    }

    private static class KryoHolder {
        private Kryo kryo;
        static final int BUFFER_SIZE = 1024;
        private Output output = new Output(1024, -1);
        private Input input = new Input();

        KryoHolder(Kryo kryo) {
            this.kryo = kryo;
        }
    }
}

