/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.redis.RedisCacheProvider;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    private String region;

    public RedisCache(String region) {
        this.region = region;
    }

    private String getKeyName(Object key) {
        if (key instanceof Number) {
            return this.region + ":I:" + key;
        }
        Class<?> keyClass = key.getClass();
        if (String.class.equals(keyClass) || StringBuffer.class.equals(keyClass) || StringBuilder.class.equals(keyClass)) {
            return this.region + ":S:" + key;
        }
        return this.region + ":O:" + key;
    }

    public static void main(String[] args) {
        RedisCache cache = new RedisCache("User");
        System.out.println(cache.getKeyName("Hello"));
        System.out.println(cache.getKeyName(2));
        System.out.println(cache.getKeyName((byte)2));
        System.out.println(cache.getKeyName(2L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) throws CacheException {
        Object obj = null;
        boolean broken = false;
        Jedis cache = RedisCacheProvider.getResource();
        try {
            if (null == key) {
                Object var5_5 = null;
                return var5_5;
            }
            byte[] b = cache.get(this.getKeyName(key).getBytes());
            if (b != null) {
                obj = SerializationUtils.deserialize(b);
            }
        }
        catch (Exception e) {
            log.error("Error occured when get data from L2 cache", (Throwable)e);
            broken = true;
            if (e instanceof IOException || e instanceof NullPointerException) {
                this.evict(key);
            }
        }
        finally {
            RedisCacheProvider.returnResource(cache, broken);
        }
        return obj;
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        if (value == null) {
            this.evict(key);
        } else {
            boolean broken = false;
            Jedis cache = RedisCacheProvider.getResource();
            try {
                cache.set(this.getKeyName(key).getBytes(), SerializationUtils.serialize(value));
            }
            catch (Exception e) {
                broken = true;
                throw new CacheException(e);
            }
            finally {
                RedisCacheProvider.returnResource(cache, broken);
            }
        }
    }

    @Override
    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    @Override
    public void evict(Object key) throws CacheException {
        boolean broken = false;
        Jedis cache = RedisCacheProvider.getResource();
        try {
            cache.del(this.getKeyName(key));
        }
        catch (Exception e) {
            broken = true;
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(cache, broken);
        }
    }

    @Override
    public void evict(List keys) throws CacheException {
        if (keys == null || keys.size() == 0) {
            return;
        }
        boolean broken = false;
        Jedis cache = RedisCacheProvider.getResource();
        try {
            String[] okeys = new String[keys.size()];
            for (int i = 0; i < okeys.length; ++i) {
                okeys[i] = this.getKeyName(keys.get(i));
            }
            cache.del(okeys);
        }
        catch (Exception e) {
            broken = true;
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(cache, broken);
        }
    }

    @Override
    public List keys() throws CacheException {
        Jedis cache = RedisCacheProvider.getResource();
        boolean broken = false;
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(cache.keys(this.region + ":*"));
            for (int i = 0; i < keys.size(); ++i) {
                keys.set(i, ((String)keys.get(i)).substring(this.region.length() + 3));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (Exception e) {
            broken = true;
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(cache, broken);
        }
    }

    @Override
    public void clear() throws CacheException {
        Jedis cache = RedisCacheProvider.getResource();
        boolean broken = false;
        try {
            String[] keys = new String[]{};
            keys = cache.keys(this.region + ":*").toArray(keys);
            cache.del(keys);
        }
        catch (Exception e) {
            broken = true;
            throw new CacheException(e);
        }
        finally {
            RedisCacheProvider.returnResource(cache, broken);
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.clear();
    }
}

