/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.util.Collection;
import java.util.List;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhCache
implements Cache,
CacheEventListener {
    private net.sf.ehcache.Cache cache;
    private CacheExpiredListener listener;

    public EhCache(net.sf.ehcache.Cache cache, CacheExpiredListener listener) {
        this.cache = cache;
        this.cache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
        this.listener = listener;
    }

    @Override
    public List keys() throws CacheException {
        return this.cache.getKeys();
    }

    @Override
    public Object get(Object key) throws CacheException {
        try {
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element != null) {
                return element.getObjectValue();
            }
            return null;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void evict(List keys) throws CacheException {
        this.cache.removeAll((Collection)keys);
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void destroy() throws CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void dispose() {
    }

    public void notifyElementEvicted(Ehcache arg0, Element arg1) {
    }

    public void notifyElementExpired(Ehcache cache, Element elem) {
        if (this.listener != null) {
            this.listener.notifyElementExpired(cache.getName(), elem.getObjectKey());
        }
    }

    public void notifyElementPut(Ehcache arg0, Element arg1) throws net.sf.ehcache.CacheException {
    }

    public void notifyElementRemoved(Ehcache arg0, Element arg1) throws net.sf.ehcache.CacheException {
    }

    public void notifyElementUpdated(Ehcache arg0, Element arg1) throws net.sf.ehcache.CacheException {
    }

    public void notifyRemoveAll(Ehcache arg0) {
    }
}

