/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.VM;

public enum Jvm {

    private static final List<String> INPUT_ARGUMENTS = ManagementFactory.getRuntimeMXBean().getInputArguments();
    private static final int COMPILE_THRESHOLD = Jvm.getCompileThreshold0(INPUT_ARGUMENTS);
    private static final boolean IS_DEBUG = INPUT_ARGUMENTS.toString().contains("jdwp") || Boolean.getBoolean("debug");
    private static final boolean IS_FLIGHT_RECORDER = (" " + ManagementFactory.getRuntimeMXBean().getInputArguments()).contains(" -XX:+FlightRecorder") || Boolean.getBoolean("jfr");
    private static final Class bitsClass;
    private static final Field reservedMemory;
    @Nullable
    private static final AtomicLong reservedMemoryAtomicLong;
    @NotNull
    private static final DirectMemoryInspector DIRECT_MEMORY_INSPECTOR;
    private static final boolean IS_64BIT;
    @NotNull
    private static ExceptionHandler FATAL;
    @NotNull
    private static ExceptionHandler WARN;
    @NotNull
    private static ExceptionHandler DEBUG;

    private static int getCompileThreshold0(@NotNull List<String> inputArguments) {
        for (String inputArgument : inputArguments) {
            String prefix;
            if (!inputArgument.startsWith(prefix = "-XX:CompileThreshold=")) continue;
            return Integer.parseInt(inputArgument.substring(prefix.length()));
        }
        return 10000;
    }

    public static int compileThreshold() {
        return COMPILE_THRESHOLD;
    }

    private static boolean is64bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    @NotNull
    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(@NotNull StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(@NotNull StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, @NotNull StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(@NotNull String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static void pause(long millis) {
        long timeNanos = millis * 1000000L;
        if ((double)timeNanos > 1.0E7) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            LockSupport.parkNanos(timeNanos);
        }
    }

    public static void busyWaitMicros(long micros) {
        Jvm.busyWaitUntil(System.nanoTime() + micros * 1000L);
    }

    public static void busyWaitUntil(long waitUntil) {
        while (waitUntil > System.nanoTime()) {
        }
    }

    public static Field getField(@NotNull Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e);
        }
    }

    public static <V> V getValue(@NotNull Object obj, @NotNull String name) {
        for (String n : name.split("/")) {
            Field f = Jvm.getField(obj.getClass(), n);
            try {
                obj = f.get(obj);
                if (obj != null) continue;
                return null;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return (V)obj;
    }

    public static String lockWithStack(@NotNull ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long usedDirectMemory() {
        return DIRECT_MEMORY_INSPECTOR.usedDirectMemory();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return VM.maxDirectMemory();
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    public static void resetExceptionHandlers() {
        FATAL = Slf4jExceptionHandler.FATAL;
        WARN = Slf4jExceptionHandler.WARN;
        DEBUG = Slf4jExceptionHandler.DEBUG;
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions() {
        return Jvm.recordExceptions(false);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug) {
        LinkedHashMap<ExceptionKey, Integer> map = new LinkedHashMap<ExceptionKey, Integer>();
        FATAL = new RecordingExceptionHandler(LogLevel.FATAL, map);
        WARN = new RecordingExceptionHandler(LogLevel.WARN, map);
        DEBUG = debug ? new RecordingExceptionHandler(LogLevel.DEBUG, map) : NullExceptionHandler.NOTHING;
        return map;
    }

    @Deprecated
    public static void setExceptionsHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        Jvm.setExceptionHandlers(fatal, warn, debug);
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        FATAL = fatal == null ? NullExceptionHandler.NOTHING : fatal;
        WARN = warn == null ? NullExceptionHandler.NOTHING : warn;
        if (debug == null) {
            Jvm.disableDebugHandler();
        } else {
            DEBUG = debug;
        }
    }

    public static void disableDebugHandler() {
        DEBUG = NullExceptionHandler.NOTHING;
    }

    @NotNull
    public static ExceptionHandler fatal() {
        return FATAL;
    }

    @NotNull
    public static ExceptionHandler warn() {
        return WARN;
    }

    @NotNull
    public static ExceptionHandler debug() {
        return DEBUG;
    }

    public static void dumpException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        for (Map.Entry<ExceptionKey, Integer> entry : exceptions.entrySet()) {
            Integer value;
            ExceptionKey key = entry.getKey();
            System.err.println((Object)((Object)key.level) + " " + key.clazz.getSimpleName() + " " + key.message);
            if (key.throwable != null) {
                key.throwable.printStackTrace();
            }
            if ((value = entry.getValue()) <= 1) continue;
            System.err.println("Repeated " + value + " times");
        }
        Jvm.resetExceptionHandlers();
    }

    public static boolean isDebugEnabled(Class aClass) {
        return DEBUG.isEnabled(aClass) || Jvm.isDebug();
    }

    static {
        IS_64BIT = Jvm.is64bit0();
        FATAL = Slf4jExceptionHandler.FATAL;
        WARN = Slf4jExceptionHandler.WARN;
        DEBUG = Slf4jExceptionHandler.DEBUG;
        try {
            bitsClass = Class.forName("java.nio.Bits");
            reservedMemory = bitsClass.getDeclaredField("reservedMemory");
            reservedMemory.setAccessible(true);
            if (reservedMemory.getType() == AtomicLong.class) {
                reservedMemoryAtomicLong = (AtomicLong)reservedMemory.get(null);
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.AtomicLong;
            } else {
                reservedMemoryAtomicLong = null;
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.Reflect;
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum DirectMemoryInspector {
        Reflect{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long usedDirectMemory() {
                try {
                    Class clazz = bitsClass;
                    synchronized (clazz) {
                        return reservedMemory.getLong(null);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        AtomicLong{

            @Override
            public long usedDirectMemory() {
                return reservedMemoryAtomicLong.get();
            }
        };


        public abstract long usedDirectMemory();
    }
}

