/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IBasicBiz;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.entity.BasicEntity;
import net.mingsoft.basic.entity.CategoryEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u57fa\u7840\u5e94\u7528\u5c42")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic"})
public class BasicAction
extends BaseAction {
    @Autowired
    private IBasicBiz basicBiz;
    @Autowired
    private ICategoryBiz categoryBiz;

    @ApiOperation(value="\u52a0\u8f7d\u9875\u9762\u663e\u793a\u6240\u6709\u6587\u7ae0\u4fe1\u606f")
    @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u7f16\u7801", required=true, paramType="query")
    @GetMapping(value={"/index"})
    public String index(HttpServletRequest request, @ApiIgnore ModelMap mode, HttpServletResponse response) {
        int appId = this.getManagerBySession(request).getBasicId();
        ModelEntity model = this.getCategoryModelCode(request);
        if (model == null) {
            this.outString(response, this.getResString("err"));
            return null;
        }
        List<CategoryEntity> list = this.categoryBiz.queryByAppIdOrModelId(appId, model.getModelId());
        JSONObject ja = new JSONObject();
        request.setAttribute("listCategory", (Object)JSONObject.toJSON(list).toString());
        return "/basic/index";
    }

    @ApiOperation(value="\u52a0\u8f7d\u6587\u7ae0\u5217\u8868\u9875\u9762\uff0c\u663e\u793a\u5217\u8868\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u680f\u76eeid", required=true, paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u6570", required=false, paramType="query")})
    @GetMapping(value={"/{categoryId}/list"})
    public String list(HttpServletRequest request, @PathVariable @ApiIgnore int categoryId) {
        String keyWord = request.getParameter("keyword");
        String categoryTitle = request.getParameter("categoryTitle");
        int pageNo = 1;
        if (request.getParameter("pageNo") != null) {
            pageNo = Integer.parseInt(request.getParameter("pageNo"));
        }
        boolean count = false;
        request.setAttribute("basicList", null);
        request.setAttribute("categoryId", (Object)categoryId);
        return "/basic/basic_list";
    }

    @ApiOperation(value="\u52a0\u8f7d\u6dfb\u52a0\u6587\u7ae0\u9875\u9762")
    @ApiImplicitParam(name="categoryId", value="\u680f\u76eeid", required=true, paramType="query")
    @GetMapping(value={"/add"})
    public String add(HttpServletRequest request, HttpServletResponse response) {
        String categoryId = request.getParameter("categoryId");
        request.setAttribute("categoryId", (Object)categoryId);
        return "/basic/basic";
    }

    @ApiOperation(value="\u4fdd\u5b58\u6587\u7ae0\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="basicModelId", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="basicAppId", value="\u6587\u7ae0\u6240\u5c5e\u5e94\u7528", required=true, paramType="query"), @ApiImplicitParam(name="basicTitle", value="\u6807\u9898 \u957f\u5ea6:200", required=false, paramType="query"), @ApiImplicitParam(name="basicDescription", value="\u63cf\u8ff0 \u957f\u5ea6:1500", required=false, paramType="query"), @ApiImplicitParam(name="basicThumbnails", value="\u7f29\u7565\u56fe \u957f\u5ea6:200", required=false, paramType="query"), @ApiImplicitParam(name="basicHit", value="\u70b9\u51fb\u6b21\u6570", required=false, paramType="query"), @ApiImplicitParam(name="basicCategoryId", value="\u6240\u5c5e\u5206\u7c7b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="basicPeopleId", value="\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="basicDateTime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="basicUpdateTime", value="\u66f4\u65b0\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="basicSort", value="\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="basicType", value="\u901a\u7528\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="basicDisplay", value="\u663e\u793a\u5c5e\u6027", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    public void save(@ModelAttribute @ApiIgnore BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
        basic.setBasicAppId(this.getAppId(request));
        basic.setBasicModelId(this.getModelCodeId(request));
        this.basicBiz.saveEntity(basic);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u52a0\u8f7d\u7f16\u8f91\u6587\u6863\u9875\u9762")
    @ApiImplicitParam(name="basicId", value="\u6587\u7ae0id", required=true, paramType="path")
    @GetMapping(value={"/{basicId}/edit"})
    public String edit(@PathVariable @ApiIgnore int basicId, HttpServletRequest request) {
        BasicEntity basic = this.basicBiz.getBasic(basicId);
        request.setAttribute("basic", (Object)basic);
        return "/basic/basic";
    }

    @ApiOperation(value="\u4fee\u6539\u6587\u7ae0\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="basicId", value="\u6587\u7ae0\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="basicTitle", value="\u6807\u9898 \u957f\u5ea6:200", required=false, paramType="query"), @ApiImplicitParam(name="basicDescription", value="\u63cf\u8ff0 \u957f\u5ea6:1500", required=false, paramType="query"), @ApiImplicitParam(name="basicThumbnails", value="\u7f29\u7565\u56fe \u957f\u5ea6:200", required=false, paramType="query"), @ApiImplicitParam(name="basicHit", value="\u70b9\u51fb\u6b21\u6570", required=false, paramType="query"), @ApiImplicitParam(name="basicCategoryId", value="\u6240\u5c5e\u5206\u7c7b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="basicPeopleId", value="\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="basicDateTime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="basicUpdateTime", value="\u66f4\u65b0\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="basicAppId", value="\u6587\u7ae0\u6240\u5c5e\u5e94\u7528", required=false, paramType="query"), @ApiImplicitParam(name="basicSort", value="\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="basicType", value="\u901a\u7528\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="basicModelId", value="\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="basicDisplay", value="\u663e\u793a\u5c5e\u6027", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
        this.basicBiz.updateBasic(basic);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u6839\u636e\u6587\u7ae0id\u5220\u9664\u6587\u7ae0\u5b9e\u4f53")
    @ApiImplicitParam(name="basicId", value="\u6587\u7ae0id", required=true, paramType="path")
    @PostMapping(value={"/{basicId}/delete"})
    @ResponseBody
    public void delete(@PathVariable @ApiIgnore int basicId, HttpServletResponse response, HttpServletRequest request) {
        this.basicBiz.deleteBasic(basicId);
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u6587\u7ae0\u591a\u9009\u5220\u9664\u65b9\u6cd5")
    @ApiImplicitParam(name="basicIds", value="\u6587\u7ae0id,\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00", required=true, paramType="path")
    @PostMapping(value={"/allDelete"})
    @ResponseBody
    public void allDelete(HttpServletResponse response, HttpServletRequest request) {
        String basicIds = request.getParameter("basicIds");
        if (!StringUtil.isBlank(basicIds)) {
            for (int i = 0; i < basicIds.split(",").length; ++i) {
                int basicId = Integer.parseInt(basicIds.split(",")[i]);
                this.basicBiz.deleteBasic(basicId);
            }
        }
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868\u63d0\u4f9b\u7ed9ajax\u4f7f\u7528")
    @GetMapping(value={"/listForAjax"})
    public void listForAjax(HttpServletResponse response, HttpServletRequest request) {
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709json\u6570\u636e")
    @ApiImplicitParam(name="categoryId", value="\u680f\u76eeid", required=true, paramType="path")
    @GetMapping(value={"/{categoryId}/query"})
    public void query(@PathVariable @ApiIgnore Integer categoryId, HttpServletRequest request, @ApiIgnore ModelMap mode, HttpServletResponse response) {
        List<BasicEntity> list = this.basicBiz.query(categoryId);
        String jsonStr = JSONObject.toJSONString(list);
        this.LOG.debug(jsonStr);
        this.outJson(response, jsonStr);
    }
}

