/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u7ba1\u7406\u63a7\u5236\u5c42\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/city/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        List cityList = this.cityBiz.query(city);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(cityList, (int)BasicUtil.endPage(cityList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762city_form")
    @ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)city.getId())) {
            BaseEntity cityEntity = this.cityBiz.getEntity(Integer.parseInt(city.getId()));
            model.addAttribute("cityEntity", (Object)cityEntity);
        }
        return "/basic/city/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)city.getId())) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("id")}));
            return;
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        this.outJson(response, _city);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        this.cityBiz.saveEntity(city);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)city)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<CityEntity> citys, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[citys.size()];
        for (int i = 0; i < citys.size(); ++i) {
            ids[i] = Integer.parseInt(citys.get(i).getId());
        }
        this.cityBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u4fe1\u606f\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        this.cityBiz.updateEntity(city);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)city)));
    }

    @ApiOperation(value="\u67e5\u8be2\u7701\u5217\u8868")
    @GetMapping(value={"/province"})
    @ResponseBody
    public void province(HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryProvince();
        this.outJson(response, JSONArray.toJSONString(cityList, (SerializeFilter[])new SerializeFilter[0]));
    }

    @ApiOperation(value="\u6839\u636e\u7701id\u67e5\u8be2\u57ce\u5e02\u5217\u8868")
    @ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=true, paramType="query")
    @GetMapping(value={"/city"})
    @ResponseBody
    public void city(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryCity(city);
        this.outJson(response, JSONArray.toJSONString(cityList, (SerializeFilter[])new SerializeFilter[0]));
    }

    @ApiOperation(value="\u6839\u636e\u57ce\u5e02id\u67e5\u8be2\u533a\u57df\u5217\u8868")
    @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=true, paramType="query")
    @GetMapping(value={"/county"})
    @ResponseBody
    public void county(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryCounty(city);
        this.outJson(response, JSONArray.toJSONString(cityList, (SerializeFilter[])new SerializeFilter[0]));
    }
}

