/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.biz.impl;

import com.mingsoft.base.biz.impl.BaseBizImpl;
import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.dao.ICategoryDao;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.util.BaseUtil;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="categoryBiz")
public class CategoryBizImpl
extends BaseBizImpl
implements ICategoryBiz {
    private ICategoryDao categoryDao;

    public int count(CategoryEntity category) {
        return this.categoryDao.count(category);
    }

    private String getGenerateFilePath(int categoryId, String categoryIds) {
        CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(Integer.valueOf(categoryId));
        int parentId = category.getCategoryCategoryId();
        if (parentId != 0) {
            categoryIds = parentId + File.separator + categoryIds;
            return this.getGenerateFilePath(parentId, categoryIds);
        }
        String path = "html" + File.separator + BasicUtil.getAppId() + File.separator + categoryIds;
        return path;
    }

    public void deleteCategory(int categoryId) {
        CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(Integer.valueOf(categoryId));
        if (category != null) {
            FileUtil.delFolders((String)BaseUtil.getRealPath((String)this.getGenerateFilePath(categoryId, categoryId + "")));
            category.setCategoryParentId(null);
            List childrenList = this.categoryDao.queryChildren(category);
            int[] ids = new int[childrenList.size()];
            for (int i = 0; i < childrenList.size(); ++i) {
                ids[i] = ((CategoryEntity)childrenList.get(i)).getCategoryId();
            }
            this.categoryDao.delete(ids);
            this.categoryDao.deleteEntity(categoryId);
            this.deleteEntity(categoryId);
        }
    }

    public ICategoryDao getCategoryDao() {
        return this.categoryDao;
    }

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    public BaseEntity getEntity(BaseEntity entity) {
        CategoryEntity category = (CategoryEntity)super.getEntity(entity);
        if (category == null) {
            return null;
        }
        List childs = this.categoryDao.query((BaseEntity)category);
        this.resetChildren(category, childs);
        return category;
    }

    public BaseEntity getEntity(int id) {
        CategoryEntity category = (CategoryEntity)super.getEntity(id);
        if (category != null) {
            List childs = this.categoryDao.queryChildren(category);
            this.resetChildren(category, childs);
        }
        return category;
    }

    public List query(BaseEntity entity) {
        List list = super.query(entity);
        ArrayList childList = new ArrayList();
        childList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            CategoryEntity c = (CategoryEntity)list.get(i);
            this.resetChildren(c, childList);
        }
        return list;
    }

    public List<CategoryEntity> queryBatchCategoryById(List<Integer> listId) {
        return this.categoryDao.queryBatchCategoryById(listId);
    }

    public List<CategoryEntity> queryByAppIdOrModelId(Integer appId, Integer modelId) {
        return this.categoryDao.queryByAppIdOrModelId(appId, modelId);
    }

    public List queryByDictId(CategoryEntity category) {
        return this.categoryDao.queryByDictId(category);
    }

    public List queryByPageList(CategoryEntity category, PageUtil page, String orderBy, boolean order) {
        return this.categoryDao.queryByPageList(category, page, orderBy, order);
    }

    public List<CategoryEntity> queryChildrenCategory(int categoryId, int appId, int modelId) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryAppId(appId);
        category.setCategoryModelId(modelId);
        category.setCategoryId(categoryId);
        return this.categoryDao.queryChildren(category);
    }

    public synchronized int[] queryChildrenCategoryIds(int categoryId, int appId, int modelId) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryAppId(appId);
        category.setCategoryModelId(modelId);
        category.setCategoryId(categoryId);
        List list = this.categoryDao.queryChildren(category);
        int[] ids = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CategoryEntity _category = (CategoryEntity)list.get(i);
            ids[i] = _category.getCategoryId();
        }
        return ids;
    }

    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChilds(category);
    }

    private void resetChildren(CategoryEntity category, List<CategoryEntity> chrildrenCategoryList) {
        for (CategoryEntity c : chrildrenCategoryList) {
            if (c.getCategoryCategoryId() != category.getCategoryId() || category.getChildrenCategoryList().contains(c)) continue;
            category.getChildrenCategoryList().add(c);
            this.resetChildren(c, chrildrenCategoryList);
        }
    }

    public int saveCategory(CategoryEntity categoryEntity) {
        if (categoryEntity.getCategoryCategoryId() > 0) {
            CategoryEntity category = (CategoryEntity)this.getEntity(categoryEntity.getCategoryCategoryId());
            if (StringUtil.isBlank((String)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(categoryEntity.getCategoryCategoryId() + "");
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + categoryEntity.getCategoryCategoryId());
            }
        }
        this.categoryDao.saveEntity((BaseEntity)categoryEntity);
        return this.saveEntity((BaseEntity)categoryEntity);
    }

    @Autowired
    public void setCategoryDao(ICategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    public void updateCategory(CategoryEntity categoryEntity) {
        if (categoryEntity.getCategoryCategoryId() > 0) {
            CategoryEntity category = (CategoryEntity)this.getEntity(categoryEntity.getCategoryCategoryId());
            if (StringUtil.isBlank((String)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(categoryEntity.getCategoryCategoryId() + "");
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + categoryEntity.getCategoryCategoryId());
            }
        }
        this.categoryDao.updateEntity((BaseEntity)categoryEntity);
        this.updateEntity((BaseEntity)categoryEntity);
    }
}

