/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action.web;

import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IRoleBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.RoleEntity;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.BaseUtil;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/${managerPath}"})
public class LoginAction
extends BaseAction {
    @Value(value="${managerPath}")
    private String managerPath;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IAppBiz appBiz;

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        if (BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION) != null) {
            return "redirect:" + this.managerPath + "/index.do";
        }
        AppEntity app = BasicUtil.getApp();
        if (app != null) {
            if (!StringUtil.isBlank((String)app.getAppLoginPage())) {
                this.LOG.debug((Object)"\u8df3\u8f6c\u81ea\u5b9a\u4e49\u767b\u5f55\u754c\u9762");
                return "redirect:" + app.getAppLoginPage();
            }
        } else {
            String defaultId;
            File file = new File(this.getRealPath(request, "WEB-INF/ms.install"));
            if (file.exists() && !StringUtil.isBlank((String)(defaultId = FileUtil.readFile((String)this.getRealPath(request, "WEB-INF/ms.install")).trim()))) {
                app = (AppEntity)this.appBiz.getEntity(Integer.parseInt(defaultId));
                app.setAppUrl(this.getUrl(request));
                this.appBiz.updateEntity((BaseEntity)app);
                FileUtil.writeFile((String)defaultId, (String)this.getRealPath(request, "WEB-INF/ms.install.bak"), (String)"utf-8");
                file.delete();
            }
        }
        request.setAttribute("app", (Object)app);
        return this.view("/login");
    }

    @RequestMapping(value={"/checkLogin"}, method={RequestMethod.POST})
    public void checkLogin(@ModelAttribute ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        AppEntity urlWebsite = null;
        urlWebsite = this.appBiz.getByUrl(this.getDomain(request));
        if (urlWebsite == null) {
            this.outJson(response, (BaseEnum)ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("app"), "!\u8bf7\u5c1d\u8bd5\u53bb\u6587\u4ef6 WEB-INF/ms.install.bak \u540e\u7f00bak"}));
            return;
        }
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        ManagerEntity _manager = (ManagerEntity)this.managerBiz.getEntity((BaseEntity)newManager);
        if (!this.checkRandCode(request)) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        if (_manager == null || StringUtil.isBlank((String)manager.getManagerName())) {
            this.outJson(response, (BaseEnum)ModelCode.ADMIN_LOGIN, false, this.getResString("err.nameEmpty"));
        } else if (StringUtil.Md5((String)manager.getManagerPassword()).equals(_manager.getManagerPassword())) {
            ManagerSessionEntity managerSession = new ManagerSessionEntity();
            AppEntity website = new AppEntity();
            RoleEntity role = (RoleEntity)this.roleBiz.getEntity(_manager.getManagerRoleID());
            website = this.appBiz.getByManagerId(role.getRoleManagerId());
            if (website != null && urlWebsite != null && urlWebsite.getAppId() == website.getAppId() && _manager.getManagerRoleID() > 1 || role.getAppId() == this.getAppId(request)) {
                if (website == null) {
                    website = BasicUtil.getApp();
                }
                List childManagerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
                managerSession.setBasicId(website.getAppId());
                managerSession.setManagerParentID(role.getRoleManagerId());
                managerSession.setManagerChildIDs(childManagerList);
                managerSession.setStyle(website.getAppStyle());
                BaseUtil.setSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION, (Object)managerSession);
            } else if (_manager.getManagerRoleID() != 1) {
                this.LOG.debug((Object)("roleId: " + _manager.getManagerRoleID()));
                this.outJson(response, (BaseEnum)ModelCode.ADMIN_LOGIN, false, this.getResString("err.not.exist", new String[]{this.getResString("manager")}));
            } else {
                BaseUtil.setSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION, (Object)managerSession);
            }
            BeanUtils.copyProperties((Object)_manager, (Object)managerSession);
            Subject subject = SecurityUtils.getSubject();
            UsernamePasswordToken upt = new UsernamePasswordToken(managerSession.getManagerName(), managerSession.getManagerPassword());
            subject.login((AuthenticationToken)upt);
            this.outJson(response, (BaseEnum)ModelCode.ADMIN_LOGIN, true, null);
        } else {
            this.outJson(response, (BaseEnum)ModelCode.ADMIN_LOGIN, false, this.getResString("err.password"));
        }
    }
}

