/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action.web;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.entity.CategoryEntity;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webCategory")
@RequestMapping(value={"/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @RequestMapping(value={"/{categoryId}/getParentCategory"})
    @ResponseBody
    public void getParentCategory(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (ObjectUtil.isNotNull((Object)category)) {
            CategoryEntity paCategory = (CategoryEntity)this.categoryBiz.getEntity(category.getCategoryCategoryId());
            if (ObjectUtil.isNull((Object)paCategory)) {
                this.outJson(response, (Object)JSONObject.toJSONString((Object)category));
            } else {
                this.outJson(response, (Object)JSONObject.toJSONString((Object)paCategory));
            }
        }
    }

    @RequestMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List list = this.categoryBiz.queryChilds(category);
            this.outJson(response, (Object)JSONObject.toJSONStringWithDateFormat((Object)list, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

