/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/app/"})
public class AppAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;

    @RequestMapping(value={"/{appId}/edit"})
    public String edit(ModelMap mode, @PathVariable int appId, HttpServletRequest request) {
        AppEntity app = null;
        if (appId < 0) {
            app = BasicUtil.getApp();
            if (app != null) {
                if (BasicUtil.getSession((String)"appId") == null) {
                    BasicUtil.setSession((String)"appId", (Object)app.getAppId());
                }
            } else {
                appId = (Integer)BasicUtil.getSession((String)"appId");
                app = (AppEntity)this.appBiz.getEntity(appId);
            }
        } else {
            app = (AppEntity)this.appBiz.getEntity(appId);
        }
        if (this.isSystemManager(request)) {
            mode.addAttribute("SystemManager", (Object)true);
        } else {
            mode.addAttribute("SystemManager", (Object)false);
        }
        mode.addAttribute("app", (Object)app);
        return this.view("/app/app");
    }

    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"app:update"})
    public void update(ModelMap mode, @ModelAttribute AppEntity app, HttpServletRequest request, HttpServletResponse response) {
        mode.clear();
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        if (managerSession == null) {
            return;
        }
        mode.addAttribute("managerSession", (Object)managerSession);
        if (!this.isSystemManager(request)) {
            app.setAppPayDate(null);
            app.setAppPay(null);
        }
        int managerRoleID = managerSession.getManagerRoleID();
        String cookie = this.getCookie(request, (BaseCookieEnum)CookieConstEnum.PAGENO_COOKIE);
        int pageNo = 1;
        if (!StringUtil.isBlank((String)cookie) && Integer.valueOf(cookie) > 0) {
            pageNo = Integer.valueOf(cookie);
        }
        mode.addAttribute("pageNo", (Object)pageNo);
        if (!this.checkForm(app, response)) {
            return;
        }
        if (!StringUtil.isBlank((String)app.getAppLogo())) {
            app.setAppLogo(app.getAppLogo().replace("|", ""));
        }
        String url = app.getAppUrl();
        String[] _url = url.split("\r\n");
        StringBuffer sb = new StringBuffer();
        for (String temp : _url) {
            String lastChar = temp.trim().substring(temp.length() - 1);
            if (lastChar.equals("/") || lastChar.equals("\\")) {
                sb.append(temp.substring(0, temp.trim().length() - 1));
            } else {
                sb.append(temp);
            }
            sb.append("\r\n");
        }
        app.setAppUrl(sb.toString());
        this.appBiz.updateEntity((BaseEntity)app);
        this.outJson(response, (BaseEnum)ModelCode.APP, true, String.valueOf(pageNo), (Object)String.valueOf(managerRoleID));
    }

    public boolean checkForm(AppEntity app, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)app.getAppKeyword(), (int)0, (int)1000)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appKeyword"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength((String)app.getAppCopyright(), (int)0, (int)1000)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appCopyright"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength((String)app.getAppDescription(), (int)0, (int)1000)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appDescrip"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength((String)app.getAppName(), (int)1, (int)50)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appTitle"), "1", "50"}));
            return false;
        }
        if (!StringUtil.isBlank((String)app.getAppStyle()) && !StringUtil.checkLength((String)app.getAppStyle(), (int)1, (int)30)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appStyle"), "1", "30"}));
            return false;
        }
        if (!StringUtil.checkLength((String)app.getAppHostUrl(), (int)10, (int)150)) {
            this.outJson(response, (BaseEnum)ModelCode.APP, false, this.getResString("err.length", new String[]{this.getResString("appUrl"), "10", "150"}));
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/checkUrl"})
    @ResponseBody
    public boolean checkUrl(HttpServletRequest request) {
        if (request.getParameter("appUrl") != null) {
            return this.appBiz.countByUrl(request.getParameter("appUrl")) > 0;
        }
        return false;
    }
}

