/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.bean.CityBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webCityAction")
@RequestMapping(value={"/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        BasicUtil.startPage();
        List cityList = this.cityBiz.query(city);
        BasicUtil.endPage(cityList);
        this.outJson(response, JSONArray.toJSONStringWithDateFormat((Object)cityList, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (StringUtil.isBlank((String)city.getId())) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("id")}));
            return;
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        this.outJson(response, _city);
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public void query(HttpServletResponse response, HttpServletRequest request) {
        int level = BasicUtil.getInt("level", 3);
        String type = BasicUtil.getString("type", "tree");
        List<CityBean> cityList = this.cityBiz.queryForTree(level, type);
        this.outJson(response, JSONArray.toJSONString(cityList));
    }
}

